namespace eval global {
    variable hyphenFile [file join $defaultDir hyphen.txt]
    array set hyphen {}
}

proc global::loadHyphenation {} {
    variable hyphenFile
    variable hyphen
    if {[file exists $hyphenFile]} {
	array unset hyphen
	array set hyphen [[lambda {file} {
	    set result {}
	    foreach name [cat $file] {
		lappend result [string map {- {}} $name] $name
	    }
	    set result
	}] $hyphenFile]
    }
}

namespace eval global {
    namespace export loadHyphenation
}

namespace import -force global::loadHyphenation

after idle loadHyphenation

proc global::hyphenWordPattern {word pattern} {
    set fragList [split $pattern -]
    set endIndex -1
    set startIndex 0
    set result {}
    foreach frag $fragList {
	set l [string length $frag]
	incr endIndex $l
	lappend result [string range $word $startIndex $endIndex]
	incr startIndex $l
    }
    join $result \u00ad
}

proc global::hyphenated {l} {
    set words [regexp -inline -all {[[:alnum:]]+} $l]
    set puncts [regexp -inline -all {[^[:alnum:]]+} $l]
    if {[regexp {[^[:alnum:]]} [string index $l 0]]} {
	set words [concat [list ""] $words]
    } 
    set result ""
    variable hyphen
    foreach word $words punct $puncts {
	set word_ [string tolower $word]
	if {[info exists hyphen($word_)]} {
	    append result [hyphenWordPattern $word $hyphen($word_)]
	} else {
	    append result $word
	}
	append result $punct
    }
    set result
}

proc global::editHyphenations {} {
    variable hyphenFile
    if {[winfo exists .hyphenation]} {
	raise .hyphenation
	focus -force .hyphenation
	return
    }
    toplevel .hyphenation
    wm title .hyphenation Silbentrennung
    wm transient .hyphenation .
    pack [scrolledtext .hyphenation.editor -width 30] -expand yes -fill both
    variable hyphenFile
    if {[file exists $hyphenFile]} {
	.hyphenation.editor insert end\
	    [join [lsort [string tolower [cat $hyphenFile]]] \n]
    }
    wm protocol .hyphenation WM_DELETE_WINDOW [subst -nocommand {
	saveString [.hyphenation.editor get 1.0 end-1chars] $hyphenFile
	destroy .hyphenation
	loadHyphenation
    }]
}

namespace eval global {
    namespace export hyphenated editHyphenations 
}

namespace import -force\
    global::hyphenated\
    global::editHyphenations