Unit Utils;

{ Turbo Pascal (version >=5.0) utilities.

  JCC  5 Dec 89

  Some of the routines here are machine dependent, and are intended to
  hide machine dependence -- notably OpenR and OpenW.
  The string handling routines and the type definitions are also somewhat
  machine dependent, but this amounts to dependence on library subprograms,
  and on the assumption that the characters can be accessed by s[i], like an
  array.

   1 Dec 89: Raw routine --- sets device to raw mode.
   6 Aug 89: Added Abbrev, CopyWord.
             Consider both tab and space as white space.
  28 Jul 89: Added FileExt.
}

{$E+}    { Force use of emulation.}
interface

uses DOS;

const
   Null = #0; bell = ^G; bsp = ^H; tab = ^I; lf = ^J;
   ff = ^L; cr = ^M; esc = #27; del = #127;

type
   FileName   = string[79];
   ScreenLine = string[80];
   LongString = String[255];

{  TIME AND DATE: }
function  Date : string;
function  Time : string;
function  Now  : string;

{ I/O UTILITIES: }
function  Ask (prompt : String) : boolean;
procedure ConvertFileExt (var Path: FileName; NewExt: ExtStr); { MACHINE DEP.}
procedure DefaultExt (var Path: FileName; DefExt: ExtStr); { MACHINE DEP.}
procedure DeleteFile (FN: FileName);                 { Machine dep.}
function  Exist (Name: FileName) : boolean;
procedure FinishBackup (SourceName, DestName, BackName: FileName;
                        var RetCode: integer);       { Machine dep. }
function  FileExt (Path: FileName): String;       { MACHINE DEP. }
function  FileTime (Path: FileName): LongInt;       { MACHINE DEP. }
procedure Inquire (prompt: String; var Answer: FileName);
function  NewFExpand (Path: PathStr): PathStr;   { MACHINE DEPENDENT }
function  OpenR (var FileVar: Text; Name: FileName): integer;  { Machine dep.}
function  OpenW (var FileVar: Text; Name: FileName): integer;  { Machine dep.}
procedure Raw (var f: text);   { HIGHLY MACHINE DEPENDENT}
function  ReNameFile (FN1, FN2: FileName) : integer; { Machine dep.}
function  SameFile (FN1, FN2: FileName) : boolean;   { Machine dep.}
procedure SetBackupNames (SourceName: FileName;
                          var DestName, BackName: FileName);  { Machine dep.}

{ STRING HANDLING: }
procedure CopyWord (var Line: LongString; var Posn: integer;
                    var w: LongString);
procedure EndWord (var Line: LongString; var Posn : integer);    { Machine dep.}
function  GoodAbbrev (a, w: LongString; min: integer): boolean;
procedure NextWord (var Line: LongString; var Posn : integer);   { Machine dep.}
procedure Replace (var target: LongString; var point: integer;
          posn, num: integer; obj: LongString);                  { Machine dep.}
procedure rtb (var str : LongString);                            { Machine dep.}
procedure rlb (var str : LongString);                            { Machine dep.}
procedure SkipSpace (var Line: LongString; var Posn : integer);  { Machine dep.}
procedure UC (var str : LongString);                             { Machine dep.}

{ MISCELLANEOUS: }
function  WordToHex(w:word) : string;   { Machine dep.}
function  ByteToHex(w:byte) : string;   { Machine dep.}
procedure TrapHeapErrorOn;              { Machine dep. Heap error->system.}
procedure TrapHeapErrorOff;             { Machine dep. Heap error->nil ptr.}

implementation
{$V-}
{ $N-}

const
   Day : array[0..6] of string[3] =
            ('Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat');
   Month : array[1..12] of string[3] =
            ('Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug',
             'Sep', 'Oct', 'Nov', 'Dec');
   HexDigit : array [0..$F] of char =
      ('0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F');

{ ------------- TIME AND DATE ------------- }

function Date : string;                          { MACHINE DEPENDENT  }
   var y, m, d, DofW : word;
       YStr, DStr : string[3];
   begin
      GetDate (y,m,d, DofW);
      Str (Y, YStr);
      Str (D, DStr);
      Date := Day[DofW] + ' ' + Month[m] + DStr + ', ' + YStr;
   end;

function Time : string;                          { MACHINE DEPENDENT  }
   var h, m, s, s100 : word;
       HStr, MStr, SStr, S100Str : string[2];
       MyTime : string;
   begin
      GetTime (h,m,s,s100);
      Str (H:2, HStr);
      Str (M:2, MStr);
      Str (S:2, SStr);
      Str (S100:2, S100Str);
      MyTime := HStr + ':' + MStr + ':' + SStr + '.' + S100Str;
      while Pos(' ',MyTime) > 0 do MyTime[Pos(' ',MyTime)] := '0';
      Time := MyTime;
   end;

function Now  : string;                          { MACHINE DEPENDENT  }
   begin Now := Time + ' on ' + Date; end;

{ ----------------- I/O UTILITIES ----------------- }

function Ask (prompt : String) : boolean;
var ch : char;
begin
     write (prompt, '? (Y or N): ');
     repeat
        readln (ch);
        ch := upcase(ch);
        if (ch in ['Y','N']) then writeln else write (bsp, ' ', bsp, bell);
        until ch in ['Y', 'N'];
     Ask := (ch = 'Y');
end;

PROCEDURE ConvertFileExt (var Path: FileName; NewExt: ExtStr); { MACHINE DEP.}
{  Replace extension by NewExt.  Put period in extension if needed.  }
 var Dir: DirStr; Name: NameStr; Ext: ExtStr;
 BEGIN 
    RLB (NewExt); 
    RTB (NewExt); 
    if (NewExt = '') or (NewExt[1] <> '.') then
       NewExt := '.' + NewExt;
    FSplit (Path, Dir, Name, Ext);
    Path := Dir + Name + NewExt;
 END; { ConvertFileExt }

PROCEDURE DefaultExt (var Path: FileName; DefExt: ExtStr); { MACHINE DEPENDENT }
{  If no extension, add extension DefExt.  Put period in extension if needed.  }
 var Dir: DirStr; Name: NameStr; Ext: ExtStr;
 BEGIN
   FSplit (Path, Dir, Name, Ext);
   if Ext = '' then ConvertFileExt (Path, DefExt);
 END; { DefaultExt }

PROCEDURE DeleteFile (FN: FileName);                 { Machine dep.}
var f: text;
 BEGIN
    if (OpenR (F, FN)  = 0)
        then begin close (F); Erase (F); end;
 END; { DeleteFile }

function Exist (Name : FileName) : boolean;
 var FileVar : text;
 begin
     if (OpenR (FileVar, Name)  = 0)
        then begin exist := true; close (FileVar); end
        else exist := false;
 end;

PROCEDURE  FinishBackup (SourceName, DestName, BackName: FileName;
                         var RetCode: integer);   { Machine dep. }
 BEGIN
    DeleteFile (BackName);
    RetCode := RenameFile (SourceName, BackName);
    RetCode := RenameFile (DestName, SourceName);
 END; { FinishBackup }

function  FileExt (Path: FileName): String;       { MACHINE DEP. }
 var Dir: DirStr; Name: NameStr; Ext: ExtStr;
 BEGIN
    RTB (Path); RLB (Path); UC  (Path);
    FSplit (Path, Dir, Name, Ext);
    FileExt := Ext;
 END; { FileExt }

function  FileTime (Path: FileName): LongInt;       { MACHINE DEP. }
   var f: file; t: LongInt;
   BEGIN
      if exist (Path) then begin
         Assign (f, Path);
         Reset (f);
         GetFTime (f, t);
         Close (f);
         FileTime := t;
      end else
         FileTime := 0;
   END; { FileTime }

procedure Inquire (prompt: String; var Answer: FileName);
   begin write (prompt); readln(Answer); uc(Answer); end;

function  NewFExpand (Path: PathStr): PathStr;   { MACHINE DEPENDENT }
{ Like Turbo FExpand, except that ensure the extension always has its period.
  and remove leading and trailing blanks, ensure UC.    }
 var Dir: DirStr; Name: NameStr; Ext: ExtStr;
 BEGIN
    RTB (Path);
    RLB (Path);
    UC  (Path);
    FSplit (Path, Dir, Name, Ext);
    if Ext = '' then Path := Path + '.';
    NewFExpand := FExpand (Path);
 END; { NewFExpand }

function  OpenR (var FileVar : Text; Name: FileName): integer;
                                                       { MACHINE DEPENDENT  }
{ Open file for reading.  Return zero for success, nonzero error }
{ code otherwise.}
begin
   assign (FileVar, Name); {$I-} reset (FileVar); {$I+}
   OpenR := IOResult;
end; { OpenR }

function  OpenW (var FileVar : Text; Name: FileName): integer;
                                                       { MACHINE DEPENDENT  }
{ Open file for writing.  Return zero for success, nonzero error }
{ code otherwise.}
begin
   assign (FileVar, Name); {$I-} rewrite (FileVar); {$I+}
   OpenW := IOResult;
end; { OpenW }

procedure Raw (var f: text);
   { Sets device defined by f to Raw mode. }
   var R: Registers;
   begin
      with R, TextRec(f) do begin
         AX := $4400;
         BX := handle;
         MSDOS(R);
         if (R.DL and $0080) = 0 then exit;  {  f is file not device. }
         AX := $4401;
         BX := handle;
         DH := 0;
         DL := R.DL or $20;
         MSDOS(R);
      end;
   end;

function  ReNameFile (FN1, FN2: FileName) : integer; { Machine dep.}
 var f: text;
    RetCode: integer;
 BEGIN
   RetCode := OpenR (F, FN1);
   ReNameFile := RetCode;
   if RetCode = 0 then begin
       close (F);
       ReName (F, FN2);
    end;
 END; { ReNameFile }

function  SameFile (FN1, FN2: FileName) : boolean;   { Machine dep.}
 begin 
    SameFile := (NewFExpand (FN1) = NewFExpand (FN2)); 
 end;

PROCEDURE SetBackupNames (SourceName: FileName; 
                          var DestName, BackName: FileName);
{ Given SourceName, set BackName to the name of the backup file (i.e.,
  extension .BAK) and set DestName to the temporary name of a file which is to
  receive the new version of the source file.  The calling routine will
  rename the old version to BackName and the new version to SourceName.  The
  temporary name (in DestName) has extension .$$$.   FinishBackup routine
  will do that.  }
BEGIN
   DestName := SourceName;
   BackName := SourceName;
   ConvertFileExt (DestName, '$$$');
   ConvertFileExt (BackName, 'BAK');
END;

{ ------------------ STRING HANDLING ----------------- }

PROCEDURE CopyWord (var Line: LongString; var Posn: integer;
                    var w: LongString);
{ Copy word from Line starting at Posn, skipping space first, if any.
  Set Posn to start of next word.
  If no word, then set w to ''.  }
var WBeg: integer;
BEGIN
   SkipSpace (Line, Posn);
   WBeg := Posn;
   EndWord (Line, Posn);
   if WBeg > length(Line) then
      w := ''
   else
      w := copy (Line, WBeg, Posn - WBeg);
   SkipSpace (Line, Posn);
END;  { CopyWord }

procedure EndWord (var Line: LongString; var Posn : integer);
                                                       { MACHINE DEPENDENT  }
begin
   if (Posn > Length(Line)) then exit;
   while (Line[Posn] <> ' ') and (Line[Posn] <> tab) do
      begin inc(Posn); if (Posn > Length(Line)) then exit; end;
end;

FUNCTION  GoodAbbrev (a, w: LongString; min: integer): boolean;
{ Tests whether a is legal abbreviation of w.  Minimum length is min.
  Force all to uppercase. If min <= 0 treat it as 1.  }
BEGIN
   UC (a);
   UC (w);
   if min <= 0 then
      min := 1;
   if length (a) >= min then
      w := copy (w, 1, length(a));
   GoodAbbrev := (a=w);
END;  { GoodAbbrev }

procedure NextWord (var Line: LongString; var Posn : integer);
begin
   EndWord (Line, Posn);
   SkipSpace (Line, Posn);
end;

procedure Replace (var target: LongString; var point: integer;
          Posn, num: integer; obj: LongString);
(*In target, replace num characters starting at Posn, update point.*)
begin
     if (Posn <= 0) or (Posn > 255) then
     begin
          writeln('Bad call to Replace');
          exit;
     end;
     delete (target, Posn, num);
     insert (obj, target, Posn);
     if (point >= Posn + num) then
          point := point + length(obj) - num
     else if (point > Posn) then
          point := Posn;
end;

procedure rtb (var str : LongString);                 { MACHINE DEPENDENT  }
    var i : integer;
 begin
    while (length (str) > 0)
         and ((str[length(str)] = ' ') or (str[length(str)] = tab)) do
       str[0] := chr(ord(str[0])-1);
 end;

procedure rlb (var str : LongString);                 { MACHINE DEPENDENT  }
    var i : integer;
 begin
    i := 1;
    while (i <= length (str))
          and ((str[i] = ' ') or (str[i] = tab)) do
       i := i + 1;
    { Now i points to first nonblank in str. }
    Delete (str, 1, i-1);
 end;

procedure SkipSpace (var Line: LongString; var Posn : integer);
                                                       { MACHINE DEPENDENT  }
begin
   if (Posn > Length(Line)) then exit;
   while (Line[Posn] = ' ') or (Line[Posn] = tab) do
      begin inc(Posn); if (Posn > Length(Line)) then exit; end;
end;

procedure UC (var str : LongString);                   { MACHINE DEPENDENT  }
    var i : integer;
    begin for i := 1 to length(str) do str[i] := upcase(str[i]); end;

{ ----------- MISCELLANEOUS -------------- }

function WordToHex(w:word) : string;                   { MACHINE DEPENDENT  }
   var i : byte;
   begin
      WordToHex[0] := char(4);
      for i := 4 downto 1 do 
         begin 
            WordToHex[i] := HexDigit[w mod 16];
            w := w div 16;
         end;
   end;

function ByteToHex(w : byte) : string;                 { MACHINE DEPENDENT  }
   var i : byte;
   begin
      ByteToHex[0] := char(2);
      for i := 2 downto 1 do 
         begin 
            ByteToHex[i] := HexDigit[w mod 16];
            w := w div 16;
         end;
   end;

{$F+} function HeapFunc0 (Size: word): integer; {$F-}
begin
   HeapFunc0 := 0;
end;


{$F+} function HeapFunc1 (Size: word): integer; {$F-}
begin
   HeapFunc1 := 1;
end;


procedure TrapHeapErrorOn;              { Machine dep. Heap error->system.}
begin
   HeapError := @HeapFunc0;
end;

procedure TrapHeapErrorOff;             { Machine dep. Heap error->nil ptr.}
begin
   HeapError := @HeapFunc1;
end;

{ ===============INITIALIZATION:======================}

begin
   TrapHeapErrorOn;
end.

