unit PrETDef;
{ Type definitions, global variables, initialization for RaTeX's drafter.  }

{$I etdirect.inc}            {Directives shared by all units}

interface

uses utils;

Const
   BUFSIZE = 20000;
   MaxBrace = 20;
   CONNAME = 'CON';  { Name of device to receive console output without
                       redirection. }

type
   ShortString = string[20];
   TextBuf = array[1..BUFSIZE] of char;
   CharSet = Set of Char;
   SubSupType = (normal, superscript, subscript);
   OneFontChar = array [1..24] of char;
   FontType = array [1..96] of OneFontChar;
   FontPtr = ^FontType;
   VMoveProc = procedure (var f: text; V: integer);
   State = record
      SourceName, DestName : FileName;
      Source, Dest : text;

      BraceLevel, NumLine: integer;
      BraceType: array[0..MaxBrace] of SubSupType;
      InEq: boolean;

      { Dimensions: normally units are dots.  }
      cw, HDPI, VDPI, eqlh, lh, srdots, charht, fracsep : integer;
      fmdots, hmdots, mbdots, mtdots, pldots, podots, rmdots : integer;
      NumbPg1, op, pn : boolean;
      foot, head : LongString;
      HPos, LineDots, Page : integer;

      Printer : ShortString;
      NoRevLF : boolean;    { If true, printer cannot rev. line feed.}
      PrtSignOn, PrtSignOff : String;
      BeginSub, EndSub, BeginSup, EndSup : string;
      UseGraph : (GrDef, GrNo, GrYes);
          {Whether user has said to use graphics or nongraphics for Greek/symbol font.}
      ThisGraphDef, GraphSwitchPoss, GreekGraphics: boolean;
              {Control use of graphics mode for Greek/symbol font}
      GreekGrLen: integer;                  {Length of bit map, per char}
      GreekGrIntro: ShortString;            {Sequence to start bit map of char}
      GreekGrFont: FontPtr;                 {pointer to array of bitmaps}
      BeginGreek, EndGreek : ShortString;
      GreekMap: array[char] of ShortString;
      GreekMapGr: array[char] of char;      {Map character in file to
                                             position in graphics font.
                                             Null if use GreekMap.  }
      BeginBold, EndBold, BeginItal, EndItal : ShortString;
      BeginULine, EndULine, SetWide, SetNar, SetLM0 : ShortString;
      cpi10, cpi12: ShortString;
      (* If cannot position print head to do fraction, then
           use following strings.  E.g. Beginfrac='\frac{',
           Midfrac = '}{', Endfrac ='}'.  *)
      Beginfrac, Midfrac, Endfrac: ShortString;
      PrtVDPI, MaxVMoveDots : integer;
      PrtVDo: VMoveProc;
   end;

const
   Letters : CharSet = ['A'..'Z', 'a'..'z'];


procedure DefaultSettings (var MyState : state);


implementation (* ============ IMPLEMENTATION ======================= *)

procedure DefaultSettings (var MyState : state);
begin
   with Mystate do begin
      HDPI := 1200;
      VDPI := 720;
      lh   := (8 * vdpi) div 48;  { Line height for text. }
      eqlh := (8 * vdpi) div 48;   { Line height for displayed equations. }
      charht := vdpi div 8;
      fracsep := charht div 4;
      if fracsep = 0 then fracsep := 1;
      cw := hdpi div 10;
      podots := HDPI div 2;
      rmdots := 8 * HDPI - 2 * podots;
      pldots := 11 * vdpi;
      hmdots := 2 * lh;
      fmdots := 3 * lh;
      mbdots := 6 * lh;
      mtdots := 4 * lh;
      op := false;
      srdots := (4 * vdpi) div 48;
      pn := true;
      head := '';
      foot := '';
      NumbPg1 := false;

      InEq := false;  { Not in equation }
      LineDots := 0;  { Before start of page  }
      Page := 1;      { Ready to start page 1 }
      HPos := -1;     { At left edge of paper; margin not set. }
   end;
end;

(* ==================== INITIALIZATION ============================  *)
begin
end.


