/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.substitutor;

import com.izforge.izpack.api.data.Value;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.substitutor.SubstitutionType;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.util.IoHelper;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class VariableSubstitutorBase
implements VariableSubstitutor {
    private static final Logger LOGGER = Logger.getLogger(VariableSubstitutorBase.class.getName());
    protected boolean bracesRequired = false;
    protected static final int TYPE_PLAIN = 0;
    protected static final int TYPE_JAVA_PROPERTIES = 1;
    protected static final int TYPE_XML = 2;
    protected static final int TYPE_SHELL = 3;
    protected static final int TYPE_AT = 4;
    protected static final int TYPE_JAVA = 5;
    protected static final int TYPE_ANT = 6;
    public static final String PLAIN = "plain";
    protected static final Map<String, Integer> typeNameToConstantMap = new HashMap<String, Integer>();

    public abstract Value getValue(String var1);

    public boolean isBracesRequired() {
        return this.bracesRequired;
    }

    @Override
    public void setBracesRequired(boolean braces) {
        this.bracesRequired = braces;
    }

    @Override
    public String substitute(String str) {
        return this.substitute(str, SubstitutionType.TYPE_PLAIN);
    }

    @Override
    public String substitute(String str, SubstitutionType type) {
        if (str == null) {
            return null;
        }
        StringReader reader = new StringReader(str);
        StringWriter writer = new StringWriter();
        try {
            this.substitute(reader, writer, type);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error when substituting variables", e);
            throw new IzPackException(e);
        }
        return writer.getBuffer().toString();
    }

    @Override
    public int substitute(InputStream in, OutputStream out, SubstitutionType type, String encoding) throws Exception {
        if (encoding == null) {
            if (type == null) {
                type = SubstitutionType.getDefault();
            }
            switch (type) {
                case TYPE_JAVA_PROPERTIES: {
                    encoding = "ISO-8859-1";
                    break;
                }
                case TYPE_XML: {
                    encoding = "UTF-8";
                }
            }
        }
        InputStreamReader reader = encoding != null ? new InputStreamReader(in, encoding) : new InputStreamReader(in);
        OutputStreamWriter writer = encoding != null ? new OutputStreamWriter(out, encoding) : new OutputStreamWriter(out);
        int subs = this.substitute(reader, writer, type);
        writer.flush();
        return subs;
    }

    @Override
    public String substitute(InputStream in, SubstitutionType type) throws Exception {
        String encoding = PLAIN;
        if (type == null) {
            type = SubstitutionType.getDefault();
        }
        switch (type) {
            case TYPE_JAVA_PROPERTIES: {
                encoding = "ISO-8859-1";
                break;
            }
            case TYPE_XML: {
                encoding = "UTF-8";
            }
        }
        InputStreamReader reader = encoding != null ? new InputStreamReader(in, encoding) : new InputStreamReader(in);
        StringWriter writer = new StringWriter();
        this.substitute(reader, writer, type);
        writer.flush();
        return writer.getBuffer().toString();
    }

    @Override
    public int substitute(Reader reader, Writer writer, SubstitutionType type) throws Exception {
        if (type == null) {
            type = SubstitutionType.getDefault();
        }
        int variable_start = 36;
        int variable_end = 0;
        switch (type) {
            case TYPE_SHELL: {
                variable_start = 37;
                break;
            }
            case TYPE_AT: {
                variable_start = 64;
                break;
            }
            case TYPE_ANT: {
                variable_start = 64;
                variable_end = 64;
                break;
            }
        }
        int subs = 0;
        int c = reader.read();
        while (true) {
            if (c != -1 && c != variable_start) {
                writer.write(c);
                c = reader.read();
                continue;
            }
            if (c == -1) {
                return subs;
            }
            boolean braces = false;
            c = reader.read();
            if (c == 123) {
                braces = true;
                c = reader.read();
            } else {
                if (this.bracesRequired) {
                    writer.write(variable_start);
                    continue;
                }
                if (c == -1) {
                    writer.write(variable_start);
                    return subs;
                }
            }
            StringBuffer nameBuffer = new StringBuffer();
            while (c != -1 && braces && c != 125 || c >= 97 && c <= 122 || c >= 65 && c <= 90 || braces && (c == 91 || c == 93) || (c >= 48 && c <= 57 || c == 95 || c == 46 || c == 45) && nameBuffer.length() > 0) {
                nameBuffer.append((char)c);
                c = reader.read();
            }
            String name = nameBuffer.toString();
            String varvalue = null;
            if (!(braces && c != 125 || braces && variable_end != 0 && variable_end != c || name.length() <= 0)) {
                if (braces && name.startsWith("ENV[") && name.lastIndexOf(93) == name.length() - 1) {
                    varvalue = IoHelper.getenv(name.substring(4, name.length() - 1));
                    if (varvalue == null) {
                        varvalue = "";
                    }
                } else if (braces && name.startsWith("SYSTEM[") && name.lastIndexOf(93) == name.length() - 1) {
                    varvalue = System.getProperty(name.substring(7, name.length() - 1));
                } else if (braces && name.startsWith("SYSTEM_") && name.length() > 7) {
                    varvalue = System.getProperty(name.substring(7).replace('_', '.'));
                } else {
                    Value val = this.getValue(name);
                    if (val != null) {
                        varvalue = val.resolve();
                    }
                }
                ++subs;
            }
            if (varvalue != null) {
                writer.write(this.escapeSpecialChars(varvalue, type));
                if (!braces && variable_end == 0) continue;
                c = reader.read();
                continue;
            }
            writer.write(variable_start);
            if (braces) {
                writer.write(123);
            }
            writer.write(name);
        }
    }

    protected int getTypeConstant(String type) {
        if (type == null) {
            return 0;
        }
        Integer integer = typeNameToConstantMap.get(type);
        if (integer == null) {
            throw new IllegalArgumentException("Unknown file type " + type);
        }
        return integer;
    }

    protected String escapeSpecialChars(String str, SubstitutionType type) {
        if (type == null) {
            type = SubstitutionType.getDefault();
        }
        switch (type) {
            case TYPE_AT: 
            case TYPE_ANT: 
            case TYPE_PLAIN: {
                return str;
            }
            case TYPE_SHELL: {
                return str.replace("\r", "");
            }
            case TYPE_JAVA_PROPERTIES: 
            case TYPE_JAVA: {
                StringBuffer buffer = new StringBuffer(str);
                int len = str.length();
                boolean leading = true;
                for (int i = 0; i < len; ++i) {
                    char c = buffer.charAt(i);
                    if (type.equals((Object)SubstitutionType.TYPE_JAVA_PROPERTIES)) {
                        if (c == '\t' || c == '\n' || c == '\r') {
                            char tag = c == '\t' ? (char)'t' : (c == '\n' ? (char)'n' : 'r');
                            buffer.replace(i, i + 1, "\\" + tag);
                            ++len;
                            ++i;
                            continue;
                        }
                        if (c == ' ') {
                            if (!leading) continue;
                            buffer.insert(i, '\\');
                            ++len;
                            ++i;
                            continue;
                        }
                        if (c == '\\' || c == '\"' || c == '\'') {
                            leading = false;
                            buffer.insert(i, '\\');
                            ++len;
                            ++i;
                            continue;
                        }
                        leading = false;
                        continue;
                    }
                    if (c != '\\') continue;
                    buffer.replace(i, i + 1, "\\\\");
                    ++len;
                    ++i;
                }
                return buffer.toString();
            }
            case TYPE_XML: {
                StringBuffer buffer = new StringBuffer(str);
                int len = str.length();
                for (int i = 0; i < len; ++i) {
                    String r = null;
                    char c = buffer.charAt(i);
                    switch (c) {
                        case '<': {
                            r = "&lt;";
                            break;
                        }
                        case '>': {
                            r = "&gt;";
                            break;
                        }
                        case '&': {
                            r = "&amp;";
                            break;
                        }
                        case '\'': {
                            r = "&apos;";
                            break;
                        }
                        case '\"': {
                            r = "&quot;";
                        }
                    }
                    if (r == null) continue;
                    buffer.replace(i, i + 1, r);
                    len = buffer.length();
                    i += r.length() - 1;
                }
                return buffer.toString();
            }
        }
        throw new Error("Unknown file type constant " + (Object)((Object)type));
    }

    static {
        typeNameToConstantMap.put(PLAIN, 0);
        typeNameToConstantMap.put("javaprop", 1);
        typeNameToConstantMap.put("java", 5);
        typeNameToConstantMap.put("xml", 2);
        typeNameToConstantMap.put("shell", 3);
        typeNameToConstantMap.put("at", 4);
        typeNameToConstantMap.put("ant", 6);
    }
}

