# Copyright (C) 1999 - Martin Strauss - under terms of GPL
###############################################################################
# set several default values
set LISTE [list basepath libpath bhtpath hlppath txtpath gifpath etcpath menupath\
inifile\
latex_exec makeindex_exec xdvi_exec dvips_exec ghostview_exec\
language readme_flag COLOR_flag\
syntax_flag KlammerFlag wsearch_gb\
SyntaxColorGreen SyntaxColorRed SyntaxColorBlue\
BlockColor ErgaenzungGray erg2_max\
wlatex_max wTcltexed_max\
myown_max max_undo]
set LFAline 0
for {set i 0} {$i < $argc} {incr i} {
 if {[string index [lindex $argv $i] 0] == "-"} then {
  switch -- [lindex $argv $i] -variable {
   puts "Possible variables are :\n"
   foreach ii $LISTE {
    eval "puts $ii=\$$ii"
   }
   puts "\nFor further discription of the meaning of the variables"
   puts "read the first part of the script tcltexed.tcl."
   exit
  } --version {
   puts "tcltexed - version $Tcltexed_Version"
   exit
  } -ind {
   set language 2
  } -bre {
   set language 3
  } -ger {
   set language 1
  } -eng {
   set language 0
  } -v {
   if {[expr $i+2] < $argc} {
    if {[lsearch $LISTE [lindex $argv [expr $i + 1]]] != -1} {
     set [lindex $argv [expr $i + 1]] [lindex $argv [expr $i + 2]]
    }
    incr i 2
   } else {
    puts "more arguments are needed by -v"
    exit
   }
  } -new {
   after 1500 NewFile
  } default {
   puts "Usage : tcltexed.tcl -- \[options\] \[+line] file1 \[+line] file2 ...\n"
   puts "A LaTeX-Editor based on Tcl/Tk"
   puts "Possible optiones are :"
   puts "  --				..end of the arguments for wish"
   puts "  -? 				..this help"
   puts "  --version			..version of tcltexed"
   puts "  -new                         ..open new file"
   puts "  -v \"variable\" \"value\" 	..set \"variable\" to a \"value\""
   puts "  -variable 			..list all possible variables"
   puts "				 and it's default values"
   puts "  -eng 				..set language to english (0)"
   puts "  -ger 				..set language to german (1)" 
   puts "  -ind 				..set language to indonesia (2)" 
   puts "  -bre 				..set language to portuguese (3)" 
   exit
  } 
 } else {
	if [string match "+*" [lindex $argv $i]] {
		set LFAline [lindex $argv $i]
	} else {
  		after 1000 LFA [lindex $argv $i] $LFAline
		set LFAline 0
	}
 }
}
proc LFA {filename line} {
 if {[info proc LoadFileArg] != ""} {
  LoadFileArg $filename $line
 } else {
  after 500 LFA $filename $line
 }
}
