# Voreinstellungsmen fr Editor
#
# Copyright (C) 2000  G. Lamprecht, W. Lotz, R. Weibezahn; IWD, Bremen University

proc ev  {} {

proc evanzeige {s1} {
 global vv We edtext editor edback edxterm edoptions efile esuff edsyntaxhelp evFoc
 $We.cb delete 0 end; $We.cb insert end "$edoptions"
 writescr0 $We.d.tt "$s1\n\n$edtext\n $vv(ev2) $editor$edback\n" \
	" $vv(ev1) $edxterm\n $vv(ev3) $edoptions\n" \
	[alternative $esuff " $vv(ev4) *\n" " $vv(ev4) $esuff\n"] \
	[alternative $efile " $vv(bad1)\n" " $vv(bad2) $efile$esuff\n\n"] \
	" edsyntaxhelp: $edsyntaxhelp"
}

proc evssel {sel} {
 global We vv tssk edsyntaxchg edsyntaxhelp
 for {set i 1} {$i<=3} {incr i} {if {$sel==$vv(evsb$i)} {set edsyntaxhelp $tssk($i)}}
 writescr0 $We.d.tt ""; set edsyntaxchg 1
}

proc evesel {s} {
 global We vv evsep edtext edxterm editor edoptions edback evesel_v
 set edtext [getvalue $s 0 $evsep]; set edxterm   [getvalue $s 1 $evsep]
 set editor [getvalue $s 2 $evsep]; set edoptions [getvalue $s 3 $evsep]
 progback editor edback; evanzeige "$vv(evt1):"; knoepfe
 set evesel_v "$s"
}

proc evfocus {w} {global We evFoc; if {$evFoc==1} {evopt}; if {$w!=""} {focus $w} {Focus $We}}

proc evopt {} {
  global We vv edoptions evFoc
  set edoptions [$We.cb get]; writescr0 $We.d.tt "$vv(aus4)\n $edoptions\n"
  set evFoc 0
}

proc evWeae {} {global We
 evfocus ""; destros $We; knoepfe; setInUnlockListe .c.1.ed; unlock_list
}

proc evWeag {} {
 global vv We editor edback edsyntaxhelp tssk evssel_v
 vstr_editor; progback editor edback; evanzeige "$vv(ausg1)"; knoepfe
 for {set i 1} {$i<=3} {incr i} {if {$edsyntaxhelp==$tssk($i)} {set evssel_v $vv(evsb$i)}}
}


global We vv edtext evsep tssk edsyntaxhelp evssel_v evFoc

toplevel_init $We "$vv(evvor)" 0 0;  set tyh 8


# top buttons

insertTopButtons $We ev_h evWeae
button $We.a.g -text "$vv(ag)" -command {evWeag}; Bind3HF $We.a.g ev_grund $We.d.tt
pack configure $We.a.g -side left -padx 3 -pady 2


# frame bv for display of personal settings

frame $We.bv; pack configure $We.bv -pady 5 -anchor w

label $We.bv.dv -text "$vv(bvdv)   " -anchor w
Bind3HF $We.bv.dv z_voreinst1 $We.d.tt
button $We.bv.va -text "$vv(bvva)" -command {evanzeige "$vv(aus0)"}
Bind3HF $We.bv.va z_voreinst1 $We.d.tt
pack configure $We.bv.dv $We.bv.va -side left


# frame for syntaxhelp and editor selection

frame $We.b; pack configure $We.b -pady 5 -padx 4 -anchor e 
frame $We.c; pack configure $We.c -pady 5 -padx 4 -anchor e -fill y -expand yes

# syntaxhelp selection
for {set i 1} {$i<=3} {incr i} {if {$edsyntaxhelp=="$tssk($i)"} {set evssel_v $vv(evsb$i)}}
CreateLSBox $We.b $vv(evs1) left 50 5 2 ev_syntaxhlp $We.d.tt \
	"" "{$vv(evsb1)} {$vv(evsb2)} {$vv(evsb3)}" evssel "" evWeae

# editor selection
set evsep [getsep editor.vst]
CreateLSBox $We.c $vv(evc1el) left 50 8 2 ev_edisel $We.d.tt \
	$evsep [vst2list editor.vst 1 $evsep "$edtext" evesel_v] evesel "" evWeae


# display and change of editor options

label $We.ca -text "$vv(evca)" -anchor sw; pack configure $We.ca -anchor sw -padx 4 -pady 2
Bind3HF $We.ca ev_optedi $We.d.tt
entry $We.cb -width 80 -relief sunken
pack configure $We.cb -anchor nw -padx 4 -fill x
bind  $We.cb <Button-1> {evfocus $We.cb; set evFoc 1}
Bind3HF $We.cb ev_optedi $We.d.tt
bind  $We.cb <Return> {evopt; evfocus ""}


InsertTextFrame $We $tyh "" "" ""

evanzeige ""; set evFoc 0
}
