# previewing  of the file $main_file with the previewer $preview   
#
# Copyright (C) 1994  G. Lamprecht, W. Lotz, R. Weibezahn; LRW c/o Uni Bremen
# Copyright (C) 1996  G. Lamprecht, W. Lotz, R. Weibezahn; IWD, Bremen University

proc preview {f austext} {

  upvar 1 $austext a
  global vv preview prback proptions main_file prsuffix pid prpreopt dirprefix tlaOutLstAct
  global sub pid unlock

  set a ""; if {$tlaOutLstAct==0} {writescr0 $f ""}


  if {$dirprefix==""} {set mfile $main_file} else {set mfile [fileName $main_file]} 

  if {$mfile==""} {set a "${a}***** $vv(ea1)\n"; mybell 2; return}

  writescr $f "[datime] $vv(pr1)  $preview $proptions $mfile$prsuffix $prback\n"


  if {$prsuffix==".ps"} {# postscript preview: recreate postscript file 

    if {[file exists "$mfile.ps"]} { # postscript file exists

      if {[file exists "$mfile.dvi"]} {
        if {[file mtime "$mfile.dvi"]>[file mtime "$mfile.ps"]} {
          writescr $f "$vv(pr2) dvips $mfile.dvi $prpreopt -o $mfile.ps\n"
	  set unlock 0; mkCmd_wait $f dvips "$mfile.dvi $prpreopt -o $mfile.ps"; set unlock 1
        }
      } 

    } else { # postscript file not found

      if {[file exists "$mfile.dvi"]} { # .dvi file exists

        writescr $f "$vv(pr3) dvips $mfile.dvi $prpreopt -o $mfile.ps\n"
	set unlock 0; mkCmd_wait $f dvips "$mfile.dvi $prpreopt -o $mfile.ps"; set unlock 1
 
      } else { # .dvi file not found either

        writescr $f "\n***** $vv(pr4) $mfile.ps $vv(pr5) $mfile.dvi)!\n$vv(pr6)\n"
        mybell 2; return

      }
    }

  }


  if {[file exists "$mfile$prsuffix"]} {
 
    set a "${a}[datime] $preview $vv(pr7)\n"

    if {$prback==""} {
     mkCmd_wait $f $preview "$proptions $mfile$prsuffix"
     set pid ""
    } else {
     SigChldB;eval set r [catch "exec $preview $proptions $mfile$prsuffix $prback" m];SigChldU
     set pid "$m";  set a "${a}$pid\n";  if {$r!=0} {set a "${a}$vv(pr8)=$r\n"}
    }

  } else {

    set a "${a}\n\n***** $vv(pr9) $mfile$prsuffix $vv(ea4)\n$vv(pr6)\n"; mybell 2; return

  }

}
