//
// Latex Project Public Licence (lppl1.3) applies
// Originally written by Kwanleung Tse
// First Release : 1st July, 2014
// Last Update : 27th September, 2014
//
//
package worker4math.hktex2;

import java.util.ArrayList;
import android.graphics.Canvas;
import android.graphics.Typeface;
import android.util.SparseArray;
import android.util.SparseBooleanArray;

import java.lang.Runnable;

    public class Parsable implements Runnable {
  
        Canvas canvas;
        Header header;
        Symbol symbol;
        SuperBlock superblock;
        Block block;
        ParagraphBlock paragraphblock;
        String lineblock;
        Integer containerwidth;
        Integer containerheight;
        Boolean twocolumns=false;
        float ypos;
        ArrayList<Typeface> tf;
      
        public static SparseBooleanArray error = new SparseBooleanArray();
        public static SparseArray<String> errormessage = new SparseArray<String>();
    	
        Source content = new Source();
        Parsedocument document = new Parsedocument();
        
        public Parsable(Canvas canvas2, Header header2, Symbol symbol2, SuperBlock superblock2, Block block2, ParagraphBlock paragraphblock2, Integer containerwidth2, Integer containerheight2, Float ypos2, ArrayList<Typeface> tf2){

        	if ((Header.tablet && Header.tablet_twocolumns) || (!Header.tablet && Header.phone_twocolumns)){
        		containerwidth=containerwidth2/2+Header.rightsidemargin/2;
        		containerheight=containerheight2;
        		twocolumns=true;
        	}else {
        		containerwidth=containerwidth2;
        		containerheight=containerheight2;
        		twocolumns=false;
        	}
        	ypos=ypos2;
        	tf=tf2;
        	canvas=canvas2;
        	header=header2;
        	symbol=symbol2;
        	superblock=superblock2;        
        	block=block2;
        	paragraphblock=paragraphblock2;
        }
      @Override
      public void run(){
    	  
    	  int startline=-1;
    	  int endline=-1;
    	  int share=0;
    	  int totalline=-1;
    	  int tid;
    	  int nthread=Header.nthread;
    	  
    	  totalline=Source.lineblock.size()-1;

          synchronized(this){
        	  tid = Thread.currentThread().getPriority(); 
        	  Header.threadid.put(Thread.currentThread().getId(),Thread.MAX_PRIORITY-tid);
        	  Thread.currentThread().setPriority(5);
        	  tid=Header.threadid.get(Thread.currentThread().getId());}
          
          synchronized(this){          
          superblock.init(tid);
          block.initerror(tid);
          }
          
          if (totalline>=nthread-1){
        	  share=(totalline+1)/nthread;
        	  startline=share*(tid);
        	  int mod=(totalline+1)%nthread;
        		  for (int i=0;i<=mod-1;i++){
        			  if (tid==i){startline=startline+i;endline=startline+share;}
        		  }
        		  for (int i=mod;i<=nthread-1;i++){
        			  if (tid==i){startline=startline+mod;endline=startline+share-1;}
        		  }
          } else {
        	  if (tid==0){Header.nthread=totalline+1;}
        	  for (int i=0;i<=totalline;i++){
        		  if (tid==i){startline=i;endline=i;}
        	  }
        	  for (int i=totalline+1;i<=nthread-1;i++){
        		  if (tid==i){startline=-1;endline=-1;}
        	  }
          }

    	  if (startline!=-1){		     		  
    		  document.parsedocument(canvas,header,symbol,superblock,block,paragraphblock,tid,startline,endline,containerwidth,containerheight,twocolumns,ypos,tf);    	  
    	      if (Parsedocument.error.get(tid)){error.put(tid, true);errormessage.put(tid,Parsedocument.errormessage.get(tid));}}
        return;
      }

    } 

	