/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.util.data;

import java.io.Serializable;
import java.util.Collection;
import org.ascape.util.data.DataPoint;

public abstract class DataPointConcrete
implements DataPoint,
Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    public static final float equalsEpsilonFloat = 1.0E-5f;
    public static final double equalsEpsilon = 1.0E-10;

    public DataPointConcrete() {
    }

    public DataPointConcrete(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public abstract double getValue(Object var1);

    public double sum(Collection collection) {
        double sum = 0.0;
        for (Object o : collection) {
            sum += this.getValue(o);
        }
        return sum;
    }

    public boolean equals(Object o1, Object o2) {
        return DataPointConcrete.equals(this.getValue(o1), this.getValue(o2));
    }

    public static final boolean equals(DataPoint dataPoint, Object o1, Object o2) {
        return DataPointConcrete.equals(dataPoint.getValue(o1), dataPoint.getValue(o2));
    }

    public static final boolean equals(double v1, double v2) {
        if (v1 == v2) {
            return true;
        }
        return Math.abs((v1 - v2) / (v1 + v2)) < 1.0E-10 || Math.abs(v1 - v2) < 1.0E-10;
    }

    public static final boolean equals(float v1, float v2) {
        if (v1 == v2) {
            return true;
        }
        return Math.abs((v1 - v2) / (v1 + v2)) < 1.0E-5f || Math.abs(v1 - v2) < 1.0E-5f;
    }

    public static double getEqualsEpsilon() {
        return 1.0E-10;
    }

    public static double getEqualsEpsilonFloat() {
        return 1.0E-5f;
    }
}

