/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.ordered.mutable;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.factory.Bags;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.primitive.BooleanLists;
import org.eclipse.collections.api.factory.primitive.ByteLists;
import org.eclipse.collections.api.factory.primitive.CharLists;
import org.eclipse.collections.api.factory.primitive.DoubleLists;
import org.eclipse.collections.api.factory.primitive.FloatLists;
import org.eclipse.collections.api.factory.primitive.IntLists;
import org.eclipse.collections.api.factory.primitive.LongLists;
import org.eclipse.collections.api.factory.primitive.ObjectDoubleMaps;
import org.eclipse.collections.api.factory.primitive.ObjectLongMaps;
import org.eclipse.collections.api.factory.primitive.ShortLists;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableBooleanList;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.map.ImmutableOrderedMap;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.map.MutableMapIterable;
import org.eclipse.collections.api.map.MutableOrderedMap;
import org.eclipse.collections.api.map.primitive.MutableObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.MutableObjectLongMap;
import org.eclipse.collections.api.multimap.list.MutableListMultimap;
import org.eclipse.collections.api.ordered.OrderedIterable;
import org.eclipse.collections.api.partition.list.PartitionMutableList;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.block.factory.Functions;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.block.factory.PrimitiveFunctions;
import org.eclipse.collections.impl.block.procedure.PartitionPredicate2Procedure;
import org.eclipse.collections.impl.block.procedure.PartitionProcedure;
import org.eclipse.collections.impl.block.procedure.SelectInstancesOfProcedure;
import org.eclipse.collections.impl.collection.mutable.CollectionAdapter;
import org.eclipse.collections.impl.list.fixed.ArrayAdapter;
import org.eclipse.collections.impl.map.AbstractMapIterable;
import org.eclipse.collections.impl.map.ordered.immutable.ImmutableOrderedMapAdapter;
import org.eclipse.collections.impl.map.ordered.mutable.UnmodifiableMutableOrderedMap;
import org.eclipse.collections.impl.multimap.list.FastListMultimap;
import org.eclipse.collections.impl.partition.list.PartitionFastList;
import org.eclipse.collections.impl.set.mutable.SetAdapter;
import org.eclipse.collections.impl.tuple.AbstractImmutableEntry;
import org.eclipse.collections.impl.utility.Iterate;
import org.eclipse.collections.impl.utility.LazyIterate;
import org.eclipse.collections.impl.utility.MapIterate;

public class OrderedMapAdapter<K, V>
extends AbstractMapIterable<K, V>
implements MutableOrderedMap<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<K, V> delegate;

    protected OrderedMapAdapter(Map<K, V> delegate) {
        if (delegate == null) {
            throw new NullPointerException("OrderedMapAdapter may not wrap null");
        }
        this.delegate = delegate;
    }

    public static <K, V> MutableOrderedMap<K, V> adapt(Map<K, V> map) {
        return map instanceof MutableOrderedMap ? (MutableOrderedMap)map : new OrderedMapAdapter<K, V>(map);
    }

    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public MutableOrderedMap<K, V> newEmpty() {
        return OrderedMapAdapter.adapt(new LinkedHashMap());
    }

    public void forEachKeyValue(Procedure2<? super K, ? super V> procedure) {
        MapIterate.forEachKeyValue(this.delegate, procedure);
    }

    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public Iterator<V> iterator() {
        return this.delegate.values().iterator();
    }

    public V remove(Object key) {
        return this.delegate.remove(key);
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        this.delegate.putAll(map);
    }

    public MutableCollection<V> values() {
        return CollectionAdapter.adapt(this.delegate.values());
    }

    public MutableSet<Map.Entry<K, V>> entrySet() {
        return SetAdapter.adapt(this.delegate.entrySet());
    }

    public MutableSet<K> keySet() {
        return SetAdapter.adapt(this.delegate.keySet());
    }

    public void clear() {
        this.delegate.clear();
    }

    public V get(Object key) {
        return this.delegate.get(key);
    }

    public V put(K key, V value) {
        return this.delegate.put(key, value);
    }

    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.delegate.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
    }

    public V removeKey(K key) {
        return this.delegate.remove(key);
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    public MutableOrderedMap<K, V> clone() {
        throw new UnsupportedOperationException();
    }

    public MutableOrderedMap<K, V> toReversed() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".toReversed() not implemented yet");
    }

    public MutableOrderedMap<K, V> take(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be greater than zero, but was: " + count);
        }
        MutableOrderedMap output = OrderedMapAdapter.adapt(new LinkedHashMap(Math.min(this.size(), count)));
        Iterator<Map.Entry<K, V>> iterator = this.delegate.entrySet().iterator();
        int countCopy = count;
        while (iterator.hasNext() && countCopy-- > 0) {
            Map.Entry<K, V> next = iterator.next();
            output.put(next.getKey(), next.getValue());
        }
        return output;
    }

    public MutableOrderedMap<K, V> takeWhile(Predicate<? super V> predicate) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".takeWhile() not implemented yet");
    }

    public MutableOrderedMap<K, V> drop(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be greater than zero, but was: " + count);
        }
        MutableOrderedMap output = OrderedMapAdapter.adapt(new LinkedHashMap(this.size() - Math.min(this.size(), count)));
        Iterator<Map.Entry<K, V>> iterator = this.delegate.entrySet().iterator();
        int start = Math.min(count, this.size());
        if (start == this.size()) {
            return output;
        }
        int i = 0;
        while (iterator.hasNext()) {
            if (i >= start) {
                Map.Entry<K, V> next = iterator.next();
                output.put(next.getKey(), next.getValue());
            } else {
                iterator.next();
            }
            ++i;
        }
        return output;
    }

    public MutableOrderedMap<K, V> dropWhile(Predicate<? super V> predicate) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".dropWhile() not implemented yet");
    }

    public PartitionMutableList<V> partitionWhile(Predicate<? super V> predicate) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".partitionWhile() not implemented yet");
    }

    public MutableList<V> distinct() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".distinct() not implemented yet");
    }

    public MutableOrderedMap<K, V> withKeyValue(K key, V value) {
        this.put(key, value);
        return this;
    }

    public MutableOrderedMap<K, V> withMap(Map<? extends K, ? extends V> map) {
        this.putAll(map);
        return this;
    }

    public MutableOrderedMap<K, V> withMapIterable(MapIterable<? extends K, ? extends V> mapIterable) {
        this.putAllMapIterable(mapIterable);
        return this;
    }

    public void putAllMapIterable(MapIterable<? extends K, ? extends V> mapIterable) {
        mapIterable.forEachKeyValue(this::put);
    }

    public MutableOrderedMap<K, V> withAllKeyValues(Iterable<? extends Pair<? extends K, ? extends V>> keyValues) {
        keyValues.forEach((? super T keyVal) -> this.put(keyVal.getOne(), keyVal.getTwo()));
        return this;
    }

    public MutableOrderedMap<K, V> withAllKeyValueArguments(Pair<? extends K, ? extends V> ... keyValues) {
        return this.withAllKeyValues((Iterable<? extends Pair<? extends K, ? extends V>>)((Object)ArrayAdapter.adapt(keyValues)));
    }

    public MutableOrderedMap<K, V> withoutKey(K key) {
        this.removeKey(key);
        return this;
    }

    public MutableOrderedMap<K, V> withoutAllKeys(Iterable<? extends K> keys) {
        keys.forEach(this::removeKey);
        return this;
    }

    public MutableOrderedMap<K, V> asUnmodifiable() {
        return UnmodifiableMutableOrderedMap.of(this);
    }

    public ImmutableOrderedMap<K, V> toImmutable() {
        return new ImmutableOrderedMapAdapter(this);
    }

    public MutableOrderedMap<K, V> asSynchronized() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".asSynchronized() not implemented yet");
    }

    public MutableListMultimap<V, K> flip() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".flip() not implemented yet");
    }

    public MutableBooleanList collectBoolean(BooleanFunction<? super V> booleanFunction) {
        return (MutableBooleanList)this.collectBoolean(booleanFunction, (MutableBooleanCollection)BooleanLists.mutable.withInitialCapacity(this.size()));
    }

    public MutableByteList collectByte(ByteFunction<? super V> byteFunction) {
        return (MutableByteList)this.collectByte(byteFunction, (MutableByteCollection)ByteLists.mutable.withInitialCapacity(this.size()));
    }

    public MutableCharList collectChar(CharFunction<? super V> charFunction) {
        return (MutableCharList)this.collectChar(charFunction, (MutableCharCollection)CharLists.mutable.withInitialCapacity(this.size()));
    }

    public MutableDoubleList collectDouble(DoubleFunction<? super V> doubleFunction) {
        return (MutableDoubleList)this.collectDouble(doubleFunction, (MutableDoubleCollection)DoubleLists.mutable.withInitialCapacity(this.size()));
    }

    public MutableFloatList collectFloat(FloatFunction<? super V> floatFunction) {
        return (MutableFloatList)this.collectFloat(floatFunction, (MutableFloatCollection)FloatLists.mutable.withInitialCapacity(this.size()));
    }

    public MutableIntList collectInt(IntFunction<? super V> intFunction) {
        return (MutableIntList)this.collectInt(intFunction, (MutableIntCollection)IntLists.mutable.withInitialCapacity(this.size()));
    }

    public MutableLongList collectLong(LongFunction<? super V> longFunction) {
        return (MutableLongList)this.collectLong(longFunction, (MutableLongCollection)LongLists.mutable.withInitialCapacity(this.size()));
    }

    public MutableShortList collectShort(ShortFunction<? super V> shortFunction) {
        return (MutableShortList)this.collectShort(shortFunction, (MutableShortCollection)ShortLists.mutable.withInitialCapacity(this.size()));
    }

    public <R> MutableOrderedMap<K, R> collectValues(Function2<? super K, ? super V, ? extends R> function) {
        return MapIterate.collectValues(this, function, OrderedMapAdapter.adapt(new LinkedHashMap(this.size())));
    }

    public <R> MutableOrderedMap<R, V> collectKeysUnique(Function2<? super K, ? super V, ? extends R> function) {
        return MapIterate.collectKeysUnique(this, function, OrderedMapAdapter.adapt(new LinkedHashMap(this.size())));
    }

    public MutableOrderedMap<K, V> tap(Procedure<? super V> procedure) {
        this.forEach(procedure);
        return this;
    }

    public MutableOrderedMap<K, V> select(Predicate2<? super K, ? super V> predicate) {
        return MapIterate.selectMapOnEntry(this, predicate, this.newEmpty());
    }

    public MutableOrderedMap<K, V> reject(Predicate2<? super K, ? super V> predicate) {
        return MapIterate.rejectMapOnEntry(this, predicate, this.newEmpty());
    }

    public <R> MutableList<R> collect(Function<? super V, ? extends R> function) {
        return this.collect(function, Lists.mutable.withInitialCapacity(this.size()));
    }

    public <P, VV> MutableList<VV> collectWith(Function2<? super V, ? super P, ? extends VV> function, P parameter) {
        return this.collect((Function<? super V, ? extends R>)((Function)Functions.bind(function, parameter)));
    }

    public <R> MutableList<R> collectIf(Predicate<? super V> predicate, Function<? super V, ? extends R> function) {
        return this.collectIf(predicate, function, Lists.mutable.empty());
    }

    public <R> MutableList<R> flatCollect(Function<? super V, ? extends Iterable<R>> function) {
        return this.flatCollect(function, Lists.mutable.withInitialCapacity(this.size()));
    }

    public MutableList<V> select(Predicate<? super V> predicate) {
        return this.select(predicate, Lists.mutable.empty());
    }

    public MutableList<V> reject(Predicate<? super V> predicate) {
        return this.reject(predicate, Lists.mutable.empty());
    }

    public <P> MutableList<V> selectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.select(Predicates.bind(predicate, parameter));
    }

    public <P> MutableList<V> rejectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.reject(Predicates.bind(predicate, parameter));
    }

    public PartitionMutableList<V> partition(Predicate<? super V> predicate) {
        PartitionFastList partitionMutableList = new PartitionFastList();
        this.forEach(new PartitionProcedure<V>(predicate, partitionMutableList));
        return partitionMutableList;
    }

    public <P> PartitionMutableList<V> partitionWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        PartitionFastList partitionMutableList = new PartitionFastList();
        this.forEach(new PartitionPredicate2Procedure<V, P>(predicate, parameter, partitionMutableList));
        return partitionMutableList;
    }

    public <S> MutableList<S> selectInstancesOf(Class<S> clazz) {
        MutableList result = Lists.mutable.withInitialCapacity(this.size());
        this.forEach(new SelectInstancesOfProcedure<S>(clazz, result));
        return result;
    }

    public <S> MutableList<Pair<V, S>> zip(Iterable<S> that) {
        return this.zip(that, Lists.mutable.withInitialCapacity(Math.min(this.size(), Iterate.sizeOf(that))));
    }

    public MutableList<Pair<V, Integer>> zipWithIndex() {
        return this.zipWithIndex(Lists.mutable.withInitialCapacity(this.size()));
    }

    public <VV> MutableListMultimap<VV, V> groupBy(Function<? super V, ? extends VV> function) {
        return this.groupBy(function, FastListMultimap.newMultimap());
    }

    public <VV> MutableListMultimap<VV, V> groupByEach(Function<? super V, ? extends Iterable<VV>> function) {
        return this.groupByEach(function, FastListMultimap.newMultimap());
    }

    public <VV> MutableOrderedMap<VV, V> groupByUniqueKey(Function<? super V, ? extends VV> function) {
        MutableOrderedMap<K, V> vs = this.newEmpty();
        return this.groupByUniqueKey(function, vs);
    }

    public <KK, VV> MutableOrderedMap<KK, VV> aggregateInPlaceBy(Function<? super V, ? extends KK> groupBy, Function0<? extends VV> zeroValueFactory, Procedure2<? super VV, ? super V> mutatingAggregator) {
        MutableOrderedMap result = this.newEmpty();
        this.forEach((Procedure & Serializable)each -> {
            Object key = groupBy.valueOf(each);
            Object value = result.getIfAbsentPut(key, zeroValueFactory);
            mutatingAggregator.value(value, each);
        });
        return result;
    }

    public <KK, VV> MutableOrderedMap<KK, VV> aggregateBy(Function<? super V, ? extends KK> groupBy, Function0<? extends VV> zeroValueFactory, Function2<? super VV, ? super V, ? extends VV> nonMutatingAggregator) {
        MutableOrderedMap<K, V> result = this.newEmpty();
        return (MutableOrderedMap)this.aggregateBy((Function)groupBy, (Function0)zeroValueFactory, (Function2)nonMutatingAggregator, (MutableMapIterable)result);
    }

    public <K1, V1, V2> MutableOrderedMap<K1, V2> aggregateBy(Function<? super K, ? extends K1> keyFunction, Function<? super V, ? extends V1> valueFunction, Function0<? extends V2> zeroValueFactory, Function2<? super V2, ? super V1, ? extends V2> nonMutatingAggregator) {
        MutableOrderedMap result = this.newEmpty();
        this.forEachKeyValue((Procedure2 & Serializable)(key, value) -> result.updateValueWith(keyFunction.valueOf(key), zeroValueFactory, nonMutatingAggregator, valueFunction.valueOf(value)));
        return result;
    }

    public <KK> MutableOrderedMap<KK, V> reduceBy(Function<? super V, ? extends KK> groupBy, Function2<? super V, ? super V, ? extends V> reduceFunction) {
        MutableOrderedMap<K, V> result = this.newEmpty();
        return (MutableOrderedMap)this.reduceBy((Function)groupBy, (Function2)reduceFunction, (MutableMapIterable)result);
    }

    public int detectLastIndex(Predicate<? super V> predicate) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".detectLastIndex() not implemented yet");
    }

    public <S> boolean corresponds(OrderedIterable<S> other, Predicate2<? super V, ? super S> predicate) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".corresponds() not implemented yet");
    }

    public void forEach(int startIndex, int endIndex, Procedure<? super V> procedure) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".forEach() not implemented yet");
    }

    public void forEachWithIndex(int fromIndex, int toIndex, ObjectIntProcedure<? super V> objectIntProcedure) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".forEachWithIndex() not implemented yet");
    }

    public MutableStack<V> toStack() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".toStack() not implemented yet");
    }

    public int detectIndex(Predicate<? super V> predicate) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".detectIndex() not implemented yet");
    }

    public V getIfAbsentPut(K key, Function0<? extends V> function) {
        Object result = this.get(key);
        if (this.isAbsent(result, key)) {
            result = function.value();
            this.put(key, result);
        }
        return result;
    }

    public V getIfAbsentPut(K key, V value) {
        V result = this.get(key);
        if (this.isAbsent(result, key)) {
            result = value;
            this.put(key, result);
        }
        return result;
    }

    public V getIfAbsentPutWithKey(K key, Function<? super K, ? extends V> function) {
        return this.getIfAbsentPutWith(key, function, key);
    }

    public <P> V getIfAbsentPutWith(K key, Function<? super P, ? extends V> function, P parameter) {
        Object result = this.get(key);
        if (this.isAbsent(result, key)) {
            result = function.valueOf(parameter);
            this.put(key, result);
        }
        return result;
    }

    public V updateValue(K key, Function0<? extends V> factory, Function<? super V, ? extends V> function) {
        V oldValue = this.getIfAbsent(key, factory);
        Object newValue = function.valueOf(oldValue);
        this.put(key, newValue);
        return (V)newValue;
    }

    public <P> V updateValueWith(K key, Function0<? extends V> factory, Function2<? super V, ? super P, ? extends V> function, P parameter) {
        V oldValue = this.getIfAbsent(key, factory);
        Object newValue = function.value(oldValue, parameter);
        this.put(key, newValue);
        return (V)newValue;
    }

    public RichIterable<K> keysView() {
        return LazyIterate.adapt(this.keySet());
    }

    public RichIterable<V> valuesView() {
        return LazyIterate.adapt(this.values());
    }

    public RichIterable<Pair<K, V>> keyValuesView() {
        return LazyIterate.adapt(this.entrySet()).collect(AbstractImmutableEntry.getPairFunction());
    }

    public <K2, V2> MutableOrderedMap<K2, V2> collect(Function2<? super K, ? super V, Pair<K2, V2>> function) {
        return MapIterate.collect(this, function, OrderedMapAdapter.adapt(new LinkedHashMap(this.size())));
    }

    public MutableOrderedMap<V, K> flipUniqueValues() {
        MutableOrderedMap result = OrderedMapAdapter.adapt(new LinkedHashMap(this.size()));
        this.delegate.forEach((? super K key, ? super V value) -> {
            Object oldKey = result.put(value, key);
            if (oldKey != null) {
                String detailMessage = String.format("Duplicate value: %s found at key: %s and key: %s", value, oldKey, key);
                throw new IllegalStateException(detailMessage);
            }
        });
        return result;
    }

    public Pair<K, V> detect(Predicate2<? super K, ? super V> predicate) {
        return MapIterate.detect(this, predicate);
    }

    public Optional<Pair<K, V>> detectOptional(Predicate2<? super K, ? super V> predicate) {
        return MapIterate.detectOptional(this, predicate);
    }

    public <V1> MutableObjectLongMap<V1> sumByInt(Function<? super V, ? extends V1> groupBy, IntFunction<? super V> function) {
        MutableObjectLongMap result = ObjectLongMaps.mutable.empty();
        return this.injectInto(result, PrimitiveFunctions.sumByIntFunction(groupBy, function));
    }

    public <V1> MutableObjectDoubleMap<V1> sumByFloat(Function<? super V, ? extends V1> groupBy, FloatFunction<? super V> function) {
        MutableObjectDoubleMap result = ObjectDoubleMaps.mutable.empty();
        return this.injectInto(result, PrimitiveFunctions.sumByFloatFunction(groupBy, function));
    }

    public <V1> MutableObjectLongMap<V1> sumByLong(Function<? super V, ? extends V1> groupBy, LongFunction<? super V> function) {
        MutableObjectLongMap result = ObjectLongMaps.mutable.empty();
        return this.injectInto(result, PrimitiveFunctions.sumByLongFunction(groupBy, function));
    }

    public <V1> MutableObjectDoubleMap<V1> sumByDouble(Function<? super V, ? extends V1> groupBy, DoubleFunction<? super V> function) {
        MutableObjectDoubleMap result = ObjectDoubleMaps.mutable.empty();
        return this.injectInto(result, PrimitiveFunctions.sumByDoubleFunction(groupBy, function));
    }

    public <V1> MutableBag<V1> countBy(Function<? super V, ? extends V1> function) {
        return this.collect(function, Bags.mutable.empty());
    }

    public <V1, P> MutableBag<V1> countByWith(Function2<? super V, ? super P, ? extends V1> function, P parameter) {
        return this.collectWith(function, parameter, Bags.mutable.empty());
    }

    @Override
    public <V1> MutableBag<V1> countByEach(Function<? super V, ? extends Iterable<V1>> function) {
        return this.flatCollect(function, Bags.mutable.empty());
    }
}

