/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.testapplication;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.comma.behavior.component.component.Component;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.parameters.parameters.Parameters;
import org.eclipse.comma.petrinet.EnvConfig;
import org.eclipse.comma.petrinet.PetrinetBuilder;
import org.eclipse.xtext.scoping.IScopeProvider;

public class TestApplicationGenerator {
    public static String generateForComponent(Component component, List<EnvConfig> environment, String adapterPath, double noEventsTimeout, double defaultTimeout, IScopeProvider scopeProvider) {
        String petrinetCode = PetrinetBuilder.forComponent((Component)component, environment, (IScopeProvider)scopeProvider, (PetrinetBuilder.Mode)PetrinetBuilder.Mode.INTERACTIVE);
        return TestApplicationGenerator.generate(petrinetCode, adapterPath, noEventsTimeout, defaultTimeout);
    }

    public static String generateForInterface(Interface itf, Parameters parameters, String adapterPath, double noEventsTimeout, double defaultTimeout, IScopeProvider scopeProvider) {
        String petrinetCode = PetrinetBuilder.forInterface((Interface)itf, (Parameters)parameters, (IScopeProvider)scopeProvider, (PetrinetBuilder.Mode)PetrinetBuilder.Mode.INTERACTIVE);
        return TestApplicationGenerator.generate(petrinetCode, adapterPath, noEventsTimeout, defaultTimeout);
    }

    private static String generate(String petrinetCode, String adapterPath, double noEventsTimeout, double defaultTimeout) {
        String code = "SELF_CONTAINED = True\nADAPTER_PATH = \"" + (adapterPath != null ? adapterPath : "") + "\"" + "\n" + "NO_EVENTS_TIMEOUT = " + (noEventsTimeout != 0.0 ? Double.valueOf(noEventsTimeout) : "5.0") + "\n" + "DEFAULT_TIMEOUT = " + (defaultTimeout != 0.0 ? Double.valueOf(defaultTimeout) : "0.1") + "\n" + PetrinetBuilder.getModelCode() + PetrinetBuilder.getWalkerCode();
        code = String.valueOf(code) + petrinetCode + "\n\n";
        code = String.valueOf(code) + "## test_application.py\n" + TestApplicationGenerator.getResourceText("/test_application.py") + "\n\n";
        return code;
    }

    private static String getResourceText(String resource) {
        InputStream stream = TestApplicationGenerator.class.getResourceAsStream(resource);
        return new BufferedReader(new InputStreamReader(stream)).lines().collect(Collectors.joining("\n"));
    }
}

