/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.diffmerge.internal.renderer.swt;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.diffmerge.internal.renderer.swt.Activator;
import org.eclipse.emf.ecp.diffmerge.internal.renderer.swt.Messages;
import org.eclipse.emf.ecp.diffmerge.spi.context.DiffMergeModelContext;
import org.eclipse.emf.ecp.diffmerge.swt.DiffDialogHelper;
import org.eclipse.emf.ecp.spi.diffmerge.model.VDiffAttachment;
import org.eclipse.emf.ecp.spi.diffmerge.model.VDiffmergePackage;
import org.eclipse.emf.ecp.view.spi.model.VAttachment;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.swt.AbstractAdditionalSWTRenderer;
import org.eclipse.emf.ecp.view.spi.swt.AbstractSWTRenderer;
import org.eclipse.emf.ecp.view.spi.swt.layout.SWTGridCell;
import org.eclipse.emf.ecp.view.spi.swt.layout.SWTGridDescription;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SWTDiffMergeAddition
extends AbstractAdditionalSWTRenderer<VControl> {
    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        SWTGridDescription addGridDescription = gridDescription.copy();
        addGridDescription.getGrid().add(new SWTGridCell(0, addGridDescription.getColumns(), (AbstractSWTRenderer)this));
        addGridDescription.setColumns(addGridDescription.getColumns() + 1);
        return addGridDescription;
    }

    protected Control renderControl(SWTGridCell cell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        if (cell.getRenderer() == this) {
            return this.createDiffButton(parent);
        }
        return null;
    }

    private Button createDiffButton(Composite parent) {
        final Button diffButton = new Button(parent, 8);
        diffButton.setText(Messages.getString("SWTDiffMergeControlRenderer.DiffButton"));
        diffButton.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_compare_button");
        diffButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                SWTDiffMergeAddition.this.openDiffDialog((DiffMergeModelContext)SWTDiffMergeAddition.this.getViewModelContext(), (VControl)SWTDiffMergeAddition.this.getVElement());
            }
        });
        for (final VAttachment attachment : ((VControl)this.getVElement()).getAttachments()) {
            if (!VDiffAttachment.class.isInstance(attachment)) continue;
            AdapterImpl adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    super.notifyChanged(msg);
                    if (msg.getFeature() == VDiffmergePackage.eINSTANCE.getDiffAttachment_MergedDiffs()) {
                        SWTDiffMergeAddition.this.updateButton(diffButton, (VDiffAttachment)attachment);
                    }
                }
            };
            attachment.eAdapters().add((Object)adapter);
            diffButton.addDisposeListener(new DisposeListener((Adapter)adapter){
                private final /* synthetic */ Adapter val$adapter;
                {
                    this.val$adapter = adapter;
                }

                public void widgetDisposed(DisposeEvent event) {
                    attachment.eAdapters().remove((Object)this.val$adapter);
                }
            });
            this.updateButton(diffButton, (VDiffAttachment)attachment);
            break;
        }
        return diffButton;
    }

    private void updateButton(Button diffButton, VDiffAttachment attachment) {
        if (attachment.getMergedDiffs() == 0) {
            diffButton.setImage(Activator.getImage("icons/lightning.png"));
        } else {
            diffButton.setImage(Activator.getImage("icons/accept.png"));
        }
    }

    private void openDiffDialog(DiffMergeModelContext diffModelContext, VControl vControl) {
        EStructuralFeature.Setting setting = (EStructuralFeature.Setting)vControl.getDomainModelReference().getIterator().next();
        if (setting == null) {
            return;
        }
        IItemPropertyDescriptor itemPropertyDescriptor = this.getItemPropertyDescriptor(setting);
        String label = itemPropertyDescriptor.getDisplayName((Object)setting.getEObject());
        DiffDialogHelper.showDialog((DiffMergeModelContext)diffModelContext, (VControl)vControl, (String)label);
    }

    private IItemPropertyDescriptor getItemPropertyDescriptor(EStructuralFeature.Setting setting) {
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        AdapterFactoryItemDelegator adapterFactoryItemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)composedAdapterFactory);
        IItemPropertyDescriptor descriptor = adapterFactoryItemDelegator.getPropertyDescriptor((Object)setting.getEObject(), (Object)setting.getEStructuralFeature());
        composedAdapterFactory.dispose();
        return descriptor;
    }
}

