/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.table.swt;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.databinding.EObjectObservableMap;
import org.eclipse.emf.databinding.edit.EMFEditObservables;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.edit.internal.swt.controls.ControlMessages;
import org.eclipse.emf.ecp.edit.internal.swt.controls.ECPFocusCellDrawHighlighter;
import org.eclipse.emf.ecp.edit.internal.swt.controls.TableViewerColumnBuilder;
import org.eclipse.emf.ecp.edit.internal.swt.util.CellEditorFactory;
import org.eclipse.emf.ecp.edit.internal.swt.util.ECPCellEditor;
import org.eclipse.emf.ecp.edit.internal.swt.util.ECPDialogExecutor;
import org.eclipse.emf.ecp.view.internal.table.swt.Activator;
import org.eclipse.emf.ecp.view.internal.table.swt.CellReadOnlyTesterHelper;
import org.eclipse.emf.ecp.view.internal.table.swt.TableConfigurationHelper;
import org.eclipse.emf.ecp.view.model.common.spi.databinding.DatabindingProviderService;
import org.eclipse.emf.ecp.view.spi.core.swt.AbstractControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.VDiagnostic;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.provider.ECPTooltipModifierHelper;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.swt.AbstractSWTRenderer;
import org.eclipse.emf.ecp.view.spi.swt.layout.GridDescriptionFactory;
import org.eclipse.emf.ecp.view.spi.swt.layout.SWTGridCell;
import org.eclipse.emf.ecp.view.spi.swt.layout.SWTGridDescription;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emf.ecp.view.spi.table.model.VTableDomainModelReference;
import org.eclipse.emf.ecp.view.template.model.VTStyleProperty;
import org.eclipse.emf.ecp.view.template.style.tableValidation.model.VTTableValidationFactory;
import org.eclipse.emf.ecp.view.template.style.tableValidation.model.VTTableValidationStyleProperty;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapCellLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationListener;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerEditorDeactivationEvent;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class TableControlSWTRenderer
extends AbstractControlSWTRenderer<VTableControl> {
    private SWTGridDescription rendererGridDescription;
    private static final String FIXED_COLUMNS = "org.eclipse.rap.rwt.fixedColumns";
    private static final String ICON_ADD = "icons/add.png";
    private static final String ICON_DELETE = "icons/delete.png";
    private TableViewer tableViewer;
    private Label validationIcon;
    private Button addButton;
    private Button removeButton;

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        if (this.rendererGridDescription == null) {
            this.rendererGridDescription = GridDescriptionFactory.INSTANCE.createSimpleGrid(1, 1, (AbstractSWTRenderer)this);
        }
        return this.rendererGridDescription;
    }

    protected Control renderControl(SWTGridCell gridCell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        Iterator settings = ((VTableControl)this.getVElement()).getDomainModelReference().getIterator();
        if (!settings.hasNext()) {
            return null;
        }
        final EStructuralFeature.Setting mainSetting = (EStructuralFeature.Setting)settings.next();
        final EClass clazz = ((EReference)mainSetting.getEStructuralFeature()).getEReferenceType();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setBackground(parent.getBackground());
        Composite titleComposite = new Composite(composite, 0);
        titleComposite.setBackground(parent.getBackground());
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)titleComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).applyTo(titleComposite);
        Label label = new Label(titleComposite, 0);
        label.setBackground(parent.getBackground());
        IItemPropertyDescriptor propDescriptor = this.getItemPropertyDescriptor(mainSetting);
        String labelText = "";
        if (propDescriptor != null) {
            labelText = propDescriptor.getDisplayName(null);
        }
        label.setText(labelText);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)label);
        this.validationIcon = this.createValidationIcon(titleComposite);
        GridDataFactory.fillDefaults().hint(16, 17).grab(false, false).applyTo((Control)this.validationIcon);
        Button addButton = null;
        Button removeButton = null;
        Composite buttonComposite = new Composite(titleComposite, 0);
        buttonComposite.setBackground(titleComposite.getBackground());
        GridDataFactory.fillDefaults().align(0x1000008, 1).grab(true, false).applyTo((Control)buttonComposite);
        int numButtons = this.addButtonsToButtonBar(buttonComposite);
        if (!((VTableControl)this.getVElement()).isAddRemoveDisabled()) {
            addButton = this.createAddRowButton(clazz, buttonComposite, mainSetting);
            removeButton = this.createRemoveRowButton(clazz, buttonComposite, mainSetting);
            numButtons += 2;
        }
        GridLayoutFactory.fillDefaults().numColumns(numButtons).equalWidth(false).applyTo(buttonComposite);
        Composite controlComposite = this.createControlComposite(composite);
        this.setTableViewer(this.createTableViewer(controlComposite, clazz, mainSetting));
        if (addButton != null && removeButton != null) {
            final Button finalAddButton = addButton;
            final Button finalRemoveButton = removeButton;
            addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableControlSWTRenderer.this.addRow(clazz, mainSetting);
                    List containments = (List)mainSetting.get(true);
                    if (mainSetting.getEStructuralFeature().getUpperBound() != -1 && containments.size() >= mainSetting.getEStructuralFeature().getUpperBound()) {
                        finalAddButton.setEnabled(false);
                    }
                    if (containments.size() > mainSetting.getEStructuralFeature().getLowerBound()) {
                        finalRemoveButton.setEnabled(true);
                    }
                }
            });
            removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IStructuredSelection selection = (IStructuredSelection)TableControlSWTRenderer.this.tableViewer.getSelection();
                    if (selection == null || selection.getFirstElement() == null) {
                        return;
                    }
                    ArrayList<EObject> deletionList = new ArrayList<EObject>();
                    Iterator iterator = selection.iterator();
                    while (iterator.hasNext()) {
                        deletionList.add((EObject)iterator.next());
                    }
                    TableControlSWTRenderer.this.deleteRowUserConfirmDialog(deletionList, mainSetting, finalAddButton, finalRemoveButton);
                }
            });
        }
        return composite;
    }

    protected int addButtonsToButtonBar(Composite buttonComposite) {
        return 0;
    }

    protected Composite createControlComposite(Composite composite) {
        Composite controlComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).hint(1, this.getTableHeightHint()).applyTo((Control)controlComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(controlComposite);
        return controlComposite;
    }

    protected int getTableHeightHint() {
        return 200;
    }

    protected TableViewer getTableViewer() {
        return this.tableViewer;
    }

    protected void setTableViewer(TableViewer tableViewer) {
        this.tableViewer = tableViewer;
    }

    private TableViewer createTableViewer(Composite composite, EClass clazz, EStructuralFeature.Setting mainSetting) {
        TableViewer tableViewer = new TableViewer(composite, 68098);
        tableViewer.getTable().setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_table");
        tableViewer.getTable().setHeaderVisible(true);
        tableViewer.getTable().setLinesVisible(true);
        TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager(tableViewer, (FocusCellHighlighter)new ECPFocusCellDrawHighlighter((ColumnViewer)tableViewer));
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)tableViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 2 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 4;
            }
        };
        TableViewerEditor.create((TableViewer)tableViewer, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
        tableViewer.getTable().setData(FIXED_COLUMNS, (Object)new Integer(1));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer);
        ObservableListContentProvider cp = new ObservableListContentProvider();
        InternalEObject tempInstance = null;
        if (!clazz.isAbstract() && !clazz.isInterface()) {
            tempInstance = this.getInstanceOf(clazz);
        }
        ECPTableViewerComparator comparator = new ECPTableViewerComparator();
        tableViewer.setComparator((ViewerComparator)comparator);
        int columnNumber = 0;
        if (!((VTableControl)this.getVElement()).isReadonly()) {
            this.createFixedValidationStatusColumn(tableViewer);
        }
        VTableDomainModelReference tableDomainModelReference = (VTableDomainModelReference)VTableDomainModelReference.class.cast(((VTableControl)this.getVElement()).getDomainModelReference());
        for (VDomainModelReference dmr : tableDomainModelReference.getColumnDomainModelReferences()) {
            Iterator eStructuralFeatureIterator;
            if (dmr == null || (eStructuralFeatureIterator = dmr.getEStructuralFeatureIterator()) == null || !eStructuralFeatureIterator.hasNext()) continue;
            EStructuralFeature eStructuralFeature = (EStructuralFeature)eStructuralFeatureIterator.next();
            String text = eStructuralFeature.getName();
            String tooltipText = eStructuralFeature.getName();
            IItemPropertyDescriptor itemPropertyDescriptor = this.getItemPropertyDescriptor(this.getCellSetting(dmr, tempInstance));
            if (itemPropertyDescriptor != null) {
                text = itemPropertyDescriptor.getDisplayName(null);
                tooltipText = itemPropertyDescriptor.getDescription(null);
            }
            CellEditor cellEditor = this.createCellEditor((EObject)tempInstance, eStructuralFeature, tableViewer.getTable());
            TableViewerColumn column = TableViewerColumnBuilder.create().setText(text).setToolTipText(tooltipText).setResizable(true).setMoveable(false).setStyle(0).setData("width", (Object)(ECPCellEditor.class.isInstance(cellEditor) ? ((ECPCellEditor)ECPCellEditor.class.cast(cellEditor)).getColumnWidthWeight() : 100)).build(tableViewer);
            column.setLabelProvider((CellLabelProvider)new ECPCellLabelProvider(eStructuralFeature, cellEditor, this.getObservableMap(dmr, eStructuralFeature, cp), (VTableControl)this.getVElement(), dmr));
            column.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(tableViewer, comparator, column.getColumn(), columnNumber));
            if (!TableConfigurationHelper.isReadOnly((VTableControl)this.getVElement(), dmr)) {
                ECPTableEditingSupport observableSupport = new ECPTableEditingSupport((ColumnViewer)tableViewer, cellEditor, (VTableControl)this.getVElement(), dmr);
                column.setEditingSupport((EditingSupport)observableSupport);
            }
            ++columnNumber;
        }
        tableViewer.setContentProvider((IContentProvider)cp);
        IObservableList list = EMFEditObservables.observeList((EditingDomain)this.getEditingDomain(mainSetting), (EObject)mainSetting.getEObject(), (EStructuralFeature)mainSetting.getEStructuralFeature());
        tableViewer.setInput((Object)list);
        TableColumnLayout layout = new TableColumnLayout();
        composite.setLayout((Layout)layout);
        int i = 0;
        while (i < tableViewer.getTable().getColumns().length) {
            Integer storedValue = (Integer)tableViewer.getTable().getColumns()[i].getData("width");
            layout.setColumnData((Widget)tableViewer.getTable().getColumns()[i], (ColumnLayoutData)new ColumnWeightData(storedValue == null ? 50 : storedValue));
            ++i;
        }
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TableControlSWTRenderer.this.viewerSelectionChanged(event);
            }
        });
        return tableViewer;
    }

    protected void viewerSelectionChanged(SelectionChangedEvent event) {
        if (event.getSelection().isEmpty()) {
            if (this.removeButton != null) {
                this.removeButton.setEnabled(false);
            }
        } else if (this.removeButton != null) {
            this.removeButton.setEnabled(true);
        }
    }

    private IObservableMap getObservableMap(VDomainModelReference dmr, EStructuralFeature eStructuralFeature, ObservableListContentProvider cp) {
        if (eStructuralFeature.isMany()) {
            return new EObjectObservableMap(cp.getKnownElements(), eStructuralFeature);
        }
        return this.getValueProperty(dmr).observeDetail(cp.getKnownElements());
    }

    private IValueProperty getValueProperty(VDomainModelReference dmr) {
        ServiceReference databindingProviderServiceReference = null;
        try {
            Collection serviceReferences = Activator.getInstance().getBundle().getBundleContext().getServiceReferences(DatabindingProviderService.class, String.format("(domainModelReference=%s)", dmr.getClass().getName()));
            Iterator iterator = serviceReferences.iterator();
            if (iterator.hasNext()) {
                databindingProviderServiceReference = (ServiceReference)iterator.next();
            }
            if (databindingProviderServiceReference == null) {
                throw new IllegalStateException("No DatabindingProviderService available.");
            }
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException(e);
        }
        DatabindingProviderService databindingProviderService = (DatabindingProviderService)Activator.getInstance().getBundle().getBundleContext().getService(databindingProviderServiceReference);
        IValueProperty result = (IValueProperty)databindingProviderService.getProperty(dmr, IValueProperty.class);
        Activator.getInstance().getBundle().getBundleContext().ungetService(databindingProviderServiceReference);
        return result;
    }

    private SelectionAdapter getSelectionAdapter(final TableViewer tableViewer, final ECPTableViewerComparator comparator, final TableColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                comparator.setColumn(index);
                int dir = comparator.getDirection();
                tableViewer.getTable().setSortDirection(dir);
                tableViewer.getTable().setSortColumn(column);
                tableViewer.refresh();
            }
        };
        return selectionAdapter;
    }

    private void createFixedValidationStatusColumn(TableViewer tableViewer) {
        VTTableValidationStyleProperty tableValidationStyleProperty = this.getTableValidationStyleProperty();
        int columnWidth = tableValidationStyleProperty.getColumnWidth();
        String columnName = tableValidationStyleProperty.getColumnName();
        String imagePath = tableValidationStyleProperty.getImagePath();
        TableViewerColumn column = TableViewerColumnBuilder.create().setMoveable(false).setText(columnName).setWidth(columnWidth).build(tableViewer);
        if (imagePath != null && !imagePath.isEmpty()) {
            Image image = null;
            try {
                image = Activator.getImage(new File(imagePath).toURI().toURL());
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
            if (image != null) {
                column.getColumn().setImage(image);
            }
        }
        column.setLabelProvider((CellLabelProvider)new ValidationStatusCellLabelProvider((VTableControl)this.getVElement()));
    }

    private VTTableValidationStyleProperty getTableValidationStyleProperty() {
        Set styleProperties = Activator.getInstance().getVTViewTemplateProvider().getStyleProperties(this.getVElement(), this.getViewModelContext());
        for (VTStyleProperty styleProperty : styleProperties) {
            if (!VTTableValidationStyleProperty.class.isInstance(styleProperty)) continue;
            VTTableValidationStyleProperty tableValidationStyleProperties = (VTTableValidationStyleProperty)VTTableValidationStyleProperty.class.cast(styleProperty);
            return tableValidationStyleProperties;
        }
        VTTableValidationStyleProperty tableValidationStyleProperties = this.getDefaultTableValidationStyleProperty();
        return tableValidationStyleProperties;
    }

    private VTTableValidationStyleProperty getDefaultTableValidationStyleProperty() {
        VTTableValidationStyleProperty tableValidationProp = VTTableValidationFactory.eINSTANCE.createTableValidationStyleProperty();
        tableValidationProp.setColumnWidth(80);
        tableValidationProp.setColumnName(ControlMessages.TableControl_ValidationStatusColumn);
        tableValidationProp.setImagePath(null);
        return tableValidationProp;
    }

    private CellEditor createCellEditor(EObject tempInstance, EStructuralFeature feature, Table table) {
        return CellEditorFactory.INSTANCE.getCellEditor(feature, tempInstance, table, this.getViewModelContext());
    }

    private InternalEObject getInstanceOf(EClass clazz) {
        return (InternalEObject)InternalEObject.class.cast(clazz.getEPackage().getEFactoryInstance().create(clazz));
    }

    private Button createRemoveRowButton(EClass clazz, Composite buttonComposite, EStructuralFeature.Setting mainSetting) {
        this.removeButton = new Button(buttonComposite, 0);
        Image image = Activator.getImage(ICON_DELETE);
        this.removeButton.setImage(image);
        this.removeButton.setEnabled(false);
        String instanceName = clazz.getInstanceClass() == null ? "" : clazz.getInstanceClass().getSimpleName();
        this.removeButton.setToolTipText(String.format(ControlMessages.TableControl_RemoveSelected, instanceName));
        List containments = (List)mainSetting.get(true);
        if (containments.size() <= mainSetting.getEStructuralFeature().getLowerBound()) {
            this.removeButton.setEnabled(false);
        }
        return this.removeButton;
    }

    private Button createAddRowButton(EClass clazz, Composite buttonComposite, EStructuralFeature.Setting mainSetting) {
        this.addButton = new Button(buttonComposite, 0);
        Image image = Activator.getImage(ICON_ADD);
        this.addButton.setImage(image);
        String instanceName = clazz.getInstanceClass() == null ? "" : clazz.getInstanceClass().getSimpleName();
        this.addButton.setToolTipText(String.format(ControlMessages.TableControl_AddInstanceOf, instanceName));
        List containments = (List)mainSetting.get(true);
        if (mainSetting.getEStructuralFeature().getUpperBound() != -1 && containments.size() >= mainSetting.getEStructuralFeature().getUpperBound()) {
            this.addButton.setEnabled(false);
        }
        return this.addButton;
    }

    protected void deleteRowUserConfirmDialog(final List<EObject> deletionList, final EStructuralFeature.Setting mainSetting, final Button addButton, final Button removeButton) {
        MessageDialog dialog = new MessageDialog(addButton.getShell(), ControlMessages.TableControl_Delete, null, ControlMessages.TableControl_DeleteAreYouSure, 5, new String[]{JFaceResources.getString((String)"yes"), JFaceResources.getString((String)"no")}, 0);
        new ECPDialogExecutor((Dialog)dialog){

            public void handleResult(int codeResult) {
                if (codeResult == 1) {
                    return;
                }
                TableControlSWTRenderer.this.deleteRows(deletionList, mainSetting);
                List containments = (List)mainSetting.get(true);
                if (containments.size() < mainSetting.getEStructuralFeature().getUpperBound()) {
                    addButton.setEnabled(true);
                }
                if (containments.size() <= mainSetting.getEStructuralFeature().getLowerBound()) {
                    removeButton.setEnabled(false);
                }
            }
        }.execute();
    }

    protected void deleteRows(List<EObject> deletionList, EStructuralFeature.Setting mainSetting) {
        EObject modelElement = mainSetting.getEObject();
        EditingDomain editingDomain = this.getEditingDomain(mainSetting);
        editingDomain.getCommandStack().execute(RemoveCommand.create((EditingDomain)editingDomain, (Object)modelElement, (Object)mainSetting.getEStructuralFeature(), deletionList));
    }

    protected void addRow(EClass clazz, EStructuralFeature.Setting mainSetting) {
        EObject modelElement = mainSetting.getEObject();
        EObject instance = clazz.getEPackage().getEFactoryInstance().create(clazz);
        EditingDomain editingDomain = this.getEditingDomain(mainSetting);
        if (editingDomain == null) {
            return;
        }
        editingDomain.getCommandStack().execute(AddCommand.create((EditingDomain)editingDomain, (Object)modelElement, (Object)mainSetting.getEStructuralFeature(), (Object)instance));
    }

    protected void applyValidation() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (TableControlSWTRenderer.this.validationIcon == null) {
                    return;
                }
                if (TableControlSWTRenderer.this.validationIcon.isDisposed()) {
                    return;
                }
                if (((VTableControl)TableControlSWTRenderer.this.getVElement()).getDiagnostic() == null) {
                    return;
                }
                TableControlSWTRenderer.this.validationIcon.setImage(TableControlSWTRenderer.this.getValidationIcon(((VTableControl)TableControlSWTRenderer.this.getVElement()).getDiagnostic().getHighestSeverity()));
                TableControlSWTRenderer.this.validationIcon.setToolTipText(((VTableControl)TableControlSWTRenderer.this.getVElement()).getDiagnostic().getMessage());
                EStructuralFeature.Setting mainSetting = (EStructuralFeature.Setting)((VTableControl)TableControlSWTRenderer.this.getVElement()).getDomainModelReference().getIterator().next();
                Collection collection = (Collection)mainSetting.get(true);
                if (!collection.isEmpty()) {
                    for (Object object : collection) {
                        TableControlSWTRenderer.this.tableViewer.update(object, null);
                    }
                }
            }
        });
    }

    protected void applyEnable() {
        if (this.addButton != null) {
            this.addButton.setVisible(((VTableControl)this.getVElement()).isEnabled() && !((VTableControl)this.getVElement()).isReadonly());
        }
        if (this.removeButton != null) {
            this.removeButton.setVisible(((VTableControl)this.getVElement()).isEnabled() && !((VTableControl)this.getVElement()).isReadonly());
        }
    }

    protected void applyReadOnly() {
        if (this.addButton != null) {
            this.addButton.setVisible(((VTableControl)this.getVElement()).isEnabled() && !((VTableControl)this.getVElement()).isReadonly());
        }
        if (this.removeButton != null) {
            this.removeButton.setVisible(((VTableControl)this.getVElement()).isEnabled() && !((VTableControl)this.getVElement()).isReadonly());
        }
    }

    protected void dispose() {
        this.rendererGridDescription = null;
        super.dispose();
    }

    private EStructuralFeature.Setting getCellSetting(VDomainModelReference domainModelReference, Object element) {
        InternalEObject eObject = (InternalEObject)InternalEObject.class.cast(element);
        VDomainModelReference copy = (VDomainModelReference)EcoreUtil.copy((EObject)domainModelReference);
        copy.init((EObject)eObject);
        Iterator iterator = copy.getIterator();
        if (iterator.hasNext()) {
            return (EStructuralFeature.Setting)iterator.next();
        }
        return null;
    }

    public class ECPCellLabelProvider
    extends ObservableMapCellLabelProvider
    implements IColorProvider {
        private final EStructuralFeature feature;
        private final CellEditor cellEditor;
        private final VTableControl vTableControl;
        private final VDomainModelReference dmr;

        public ECPCellLabelProvider(EStructuralFeature feature, CellEditor cellEditor, IObservableMap attributeMap, VTableControl vTableControl, VDomainModelReference dmr) {
            super(attributeMap);
            this.vTableControl = vTableControl;
            this.feature = feature;
            this.cellEditor = cellEditor;
            this.dmr = dmr;
        }

        public String getToolTipText(Object element) {
            EObject domainObject = (EObject)element;
            VDomainModelReference copy = (VDomainModelReference)EcoreUtil.copy((EObject)this.dmr);
            copy.init(domainObject);
            Iterator iterator = copy.getIterator();
            EStructuralFeature.Setting setting = null;
            if (!iterator.hasNext()) {
                return null;
            }
            setting = (EStructuralFeature.Setting)iterator.next();
            StringBuffer tooltip = new StringBuffer();
            VDiagnostic vDiagnostic = this.vTableControl.getDiagnostic();
            List diagnostics = vDiagnostic.getDiagnostic(domainObject, this.feature);
            for (Diagnostic diagnostic : diagnostics) {
                if (tooltip.length() > 0) {
                    tooltip.append("\n");
                }
                tooltip.append(diagnostic.getMessage());
            }
            if (tooltip.length() != 0) {
                return ECPTooltipModifierHelper.modifyString((String)tooltip.toString(), (EStructuralFeature.Setting)setting);
            }
            Object value = setting.get(true);
            if (value == null) {
                return null;
            }
            return ECPTooltipModifierHelper.modifyString((String)String.valueOf(value), (EStructuralFeature.Setting)setting);
        }

        public void update(ViewerCell cell) {
            EObject element = (EObject)cell.getElement();
            Object value = this.attributeMaps[0].get((Object)element);
            if (ECPCellEditor.class.isInstance(this.cellEditor)) {
                ECPCellEditor ecpCellEditor = (ECPCellEditor)this.cellEditor;
                String text = ecpCellEditor.getFormatedString(value);
                cell.setText(text == null ? "" : text);
            } else {
                cell.setText(value == null ? "" : value.toString());
                cell.getControl().setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_edit_cellEditor_string");
            }
            cell.setBackground(this.getBackground(element));
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Color getBackground(Object element) {
            VDiagnostic vDiagnostic = this.vTableControl.getDiagnostic();
            if (vDiagnostic == null) {
                return TableControlSWTRenderer.this.getValidationBackgroundColor(0);
            }
            List diagnostic = vDiagnostic.getDiagnostic((EObject)element, this.feature);
            return TableControlSWTRenderer.this.getValidationBackgroundColor(diagnostic.size() == 0 ? 0 : ((Diagnostic)diagnostic.get(0)).getSeverity());
        }
    }

    private class ECPTableEditingSupport
    extends EditingSupport {
        private final CellEditor cellEditor;
        private final VTableControl tableControl;
        private final VDomainModelReference domainModelReference;
        private EditingState editingState;
        private final ColumnViewerEditorActivationListenerHelper activationListener;

        public ECPTableEditingSupport(ColumnViewer viewer, CellEditor cellEditor, VTableControl tableControl, VDomainModelReference domainModelReference) {
            super(viewer);
            this.activationListener = new ColumnViewerEditorActivationListenerHelper();
            this.cellEditor = cellEditor;
            this.tableControl = tableControl;
            this.domainModelReference = domainModelReference;
        }

        protected boolean canEdit(Object element) {
            boolean editable = this.tableControl.isEnabled() && !this.tableControl.isReadonly();
            EStructuralFeature.Setting setting = TableControlSWTRenderer.this.getCellSetting(this.domainModelReference, element);
            if (setting == null) {
                return false;
            }
            editable &= TableControlSWTRenderer.this.getItemPropertyDescriptor(setting).canSetProperty(null);
            editable &= !CellReadOnlyTesterHelper.getInstance().isReadOnly((VTableControl)TableControlSWTRenderer.this.getVElement(), setting);
            if (ECPCellEditor.class.isInstance(this.cellEditor)) {
                ((ECPCellEditor)ECPCellEditor.class.cast(this.cellEditor)).setEditable(editable);
                return true;
            }
            return editable;
        }

        protected Object getValue(Object element) {
            return null;
        }

        protected void setValue(Object element, Object value) {
        }

        protected void initializeCellEditorValue(CellEditor cellEditor, ViewerCell cell) {
            IObservableValue target = this.doCreateCellEditorObservable(cellEditor);
            Assert.isNotNull((Object)target, (String)"doCreateCellEditorObservable(...) did not return an observable");
            IObservableValue model = this.doCreateElementObservable(cell.getElement(), cell);
            Assert.isNotNull((Object)model, (String)"doCreateElementObservable(...) did not return an observable");
            Binding binding = this.createBinding(target, model);
            Assert.isNotNull((Object)binding, (String)"createBinding(...) did not return a binding");
            this.editingState = new EditingState(binding, target, model);
            this.getViewer().getColumnViewerEditor().addEditorActivationListener((ColumnViewerEditorActivationListener)this.activationListener);
        }

        protected CellEditor getCellEditor(Object element) {
            return this.cellEditor;
        }

        protected Binding createBinding(IObservableValue target, IObservableValue model) {
            if (ECPCellEditor.class.isInstance(this.cellEditor)) {
                return TableControlSWTRenderer.this.getDataBindingContext().bindValue(target, model, ((ECPCellEditor)this.cellEditor).getTargetToModelStrategy(), ((ECPCellEditor)this.cellEditor).getModelToTargetStrategy());
            }
            return TableControlSWTRenderer.this.getDataBindingContext().bindValue(target, model);
        }

        protected IObservableValue doCreateElementObservable(Object element, ViewerCell cell) {
            return TableControlSWTRenderer.this.getValueProperty(this.domainModelReference).observe(element);
        }

        protected IObservableValue doCreateCellEditorObservable(CellEditor cellEditor) {
            if (ECPCellEditor.class.isInstance(cellEditor)) {
                return ((ECPCellEditor)cellEditor).getValueProperty().observe((Object)cellEditor);
            }
            return SWTObservables.observeText((Control)cellEditor.getControl(), (int)16);
        }

        protected final void saveCellEditorValue(CellEditor cellEditor, ViewerCell cell) {
            this.editingState.binding.updateTargetToModel();
        }

        private class ColumnViewerEditorActivationListenerHelper
        extends ColumnViewerEditorActivationListener {
            private ColumnViewerEditorActivationListenerHelper() {
            }

            public void afterEditorActivated(ColumnViewerEditorActivationEvent event) {
            }

            public void afterEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
                ECPTableEditingSupport.this.editingState.dispose();
                ECPTableEditingSupport.this.editingState = null;
                ECPTableEditingSupport.this.getViewer().getColumnViewerEditor().removeEditorActivationListener((ColumnViewerEditorActivationListener)this);
                ViewerCell focusCell = ECPTableEditingSupport.this.getViewer().getColumnViewerEditor().getFocusCell();
                if (focusCell != null) {
                    ECPTableEditingSupport.this.getViewer().update(focusCell.getElement(), null);
                }
            }

            public void beforeEditorActivated(ColumnViewerEditorActivationEvent event) {
            }

            public void beforeEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
            }
        }

        class EditingState {
            private final IObservableValue target;
            private final IObservableValue model;
            private final Binding binding;

            EditingState(Binding binding, IObservableValue target, IObservableValue model) {
                this.binding = binding;
                this.target = target;
                this.model = model;
            }

            void dispose() {
                this.binding.dispose();
                this.target.dispose();
                this.model.dispose();
            }
        }
    }

    private class ECPTableViewerComparator
    extends ViewerComparator {
        private int propertyIndex = 0;
        private static final int NONE = 0;
        private int direction = 0;

        public int getDirection() {
            switch (this.direction) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 128;
                }
                case 2: {
                    return 1024;
                }
            }
            return 0;
        }

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction = (this.direction + 1) % 3;
            } else {
                this.propertyIndex = column;
                this.direction = 1;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (this.direction == 0) {
                return 0;
            }
            int rc = 0;
            EObject object1 = (EObject)e1;
            EObject object2 = (EObject)e2;
            EStructuralFeature feat1 = (EStructuralFeature)object1.eClass().getEAllStructuralFeatures().get(this.propertyIndex);
            EStructuralFeature feat2 = (EStructuralFeature)object2.eClass().getEAllStructuralFeatures().get(this.propertyIndex);
            Object value1 = object1.eGet(feat1);
            Object value2 = object2.eGet(feat2);
            rc = value1 == null ? 1 : (value2 == null ? -1 : value1.toString().compareTo(value2.toString()));
            if (this.direction == 2) {
                rc = -rc;
            }
            return rc;
        }
    }

    private class ValidationStatusCellLabelProvider
    extends CellLabelProvider {
        private final VTableControl vTableControl;

        public ValidationStatusCellLabelProvider(VTableControl vTableControl) {
            this.vTableControl = vTableControl;
        }

        public void update(ViewerCell cell) {
            Integer mostSevere = 0;
            VDiagnostic vDiagnostic = this.vTableControl.getDiagnostic();
            if (vDiagnostic == null) {
                return;
            }
            List diagnostics = vDiagnostic.getDiagnostics((EObject)cell.getElement());
            if (diagnostics.size() != 0) {
                mostSevere = ((Diagnostic)diagnostics.get(0)).getSeverity();
            }
            cell.setImage(TableControlSWTRenderer.this.getValidationIcon(mostSevere));
        }

        public String getToolTipText(Object element) {
            StringBuffer tooltip = new StringBuffer();
            VDiagnostic vDiagnostic = this.vTableControl.getDiagnostic();
            List diagnostics = vDiagnostic.getDiagnostics((EObject)element);
            for (Diagnostic diagnostic : diagnostics) {
                if (tooltip.length() > 0) {
                    tooltip.append("\n");
                }
                tooltip.append(diagnostic.getMessage());
            }
            return tooltip.toString();
        }
    }
}

