/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ManagedScheduledExecutorService.resourcedef;

import ee.jakarta.tck.concurrent.common.context.IntContext;
import ee.jakarta.tck.concurrent.common.context.StringContext;
import jakarta.enterprise.concurrent.Asynchronous;
import jakarta.enterprise.concurrent.ContextService;
import jakarta.enterprise.context.RequestScoped;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import javax.naming.NamingException;

@RequestScoped
public class ReqBean {
    private static final long MAX_WAIT_SECONDS = TimeUnit.MINUTES.toSeconds(2L);

    @Asynchronous(executor="java:app/concurrent/ScheduledExecutorA")
    public CompletableFuture<String> awaitAndGetThirdPartyContext(Semaphore invocationsStarted, CountDownLatch blocker) {
        invocationsStarted.release(1);
        CompletableFuture future = Asynchronous.Result.getFuture();
        try {
            blocker.await(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
            future.complete(IntContext.get() + StringContext.get());
        }
        catch (Exception x) {
            future.completeExceptionally(x);
        }
        return future;
    }

    @Asynchronous(executor="java:comp/concurrent/ScheduledExecutorC")
    public CompletionStage<ContextService> lookUpAContextService() {
        try {
            return CompletableFuture.completedFuture((ContextService)InitialContext.doLookup("java:comp/concurrent/ContextC"));
        }
        catch (NamingException x) {
            throw new CompletionException(x);
        }
    }

    public CompletableFuture<String> notAsynchronous() {
        return CompletableFuture.completedFuture(Thread.currentThread().getName());
    }
}

