/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.archive;

import jakarta.ejb.MessageDriven;
import jakarta.ejb.Singleton;
import jakarta.ejb.Stateful;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.ejb.deployment.archive.EjbType;
import org.glassfish.internal.deployment.GenericSniffer;
import org.jvnet.hk2.annotations.Service;

@Service(name="Ejb")
@jakarta.inject.Singleton
public class EjbSniffer
extends GenericSniffer {
    @Inject
    EjbType ejbType;
    private static final Class[] ejbAnnotations = new Class[]{Stateless.class, Stateful.class, MessageDriven.class, Singleton.class};
    final String[] containers = new String[]{"org.glassfish.ejb.startup.EjbContainerStarter"};
    private static final List<String> deploymentConfigurationPaths = EjbSniffer.initDeploymentConfigurationPaths();

    public EjbSniffer() {
        this("ejb", "META-INF/ejb-jar.xml", null);
    }

    public EjbSniffer(String containerName, String appStigma, String urlPattern) {
        super(containerName, appStigma, urlPattern);
    }

    public String[] getContainersNames() {
        return this.containers;
    }

    public boolean handles(ReadableArchive location) {
        boolean result = super.handles(location);
        if (!result) {
            try {
                result = location.exists("META-INF/sun-ejb-jar.xml") || location.exists("META-INF/glassfish-ejb-jar.xml");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!result) {
            try {
                result = location.exists("WEB-INF/ejb-jar.xml");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    public Class<? extends Annotation>[] getAnnotationTypes() {
        return ejbAnnotations;
    }

    public boolean isUserVisible() {
        return true;
    }

    public boolean isJakartaEE() {
        return true;
    }

    public String[] getIncompatibleSnifferTypes() {
        return new String[]{"connector"};
    }

    public boolean supportsArchiveType(ArchiveType archiveType) {
        return archiveType.equals((Object)this.ejbType) || archiveType.toString().equals("war");
    }

    private static List<String> initDeploymentConfigurationPaths() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("META-INF/ejb-jar.xml");
        result.add("META-INF/sun-ejb-jar.xml");
        result.add("META-INF/glassfish-ejb-jar.xml");
        result.add("META-INF/weblogic-ejb-jar.xml");
        return result;
    }

    protected List<String> getDeploymentConfigurationPaths() {
        return deploymentConfigurationPaths;
    }
}

