/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.sse.internal;

import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.sse.InboundSseEvent;
import jakarta.ws.rs.sse.SseEventSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.client.ClientExecutor;
import org.glassfish.jersey.client.JerseyWebTarget;
import org.glassfish.jersey.internal.util.JerseyPublisher;
import org.glassfish.jersey.media.sse.LocalizationMessages;
import org.glassfish.jersey.media.sse.internal.EventProcessor;

public class JerseySseEventSource
implements SseEventSource {
    private static final long DEFAULT_RECONNECT_DELAY = 500L;
    private static final Logger LOGGER = Logger.getLogger(JerseySseEventSource.class.getName());
    private static final Consumer<Flow.Subscription> DEFAULT_SUBSCRIPTION_HANDLER = sseSubscription -> sseSubscription.request(Long.MAX_VALUE);
    private static final Consumer<Throwable> DEFAULT_ERROR_HANDLER = throwable -> LOGGER.log(Level.WARNING, LocalizationMessages.EVENT_SOURCE_DEFAULT_ONERROR(), (Throwable)throwable);
    private JerseyPublisher<InboundSseEvent> publisher;
    private final AtomicReference<EventProcessor.State> state = new AtomicReference<EventProcessor.State>(EventProcessor.State.READY);
    private final JerseyWebTarget endpoint;
    private final long reconnectDelay;
    private final TimeUnit reconnectTimeUnit;
    private final ClientExecutor clientExecutor;
    private final List<Consumer<Throwable>> throwableConsumers = new ArrayList<Consumer<Throwable>>();

    private JerseySseEventSource(JerseyWebTarget endpoint, long reconnectDelay, TimeUnit reconnectTimeUnit) {
        this.endpoint = endpoint;
        this.reconnectDelay = reconnectDelay;
        this.reconnectTimeUnit = reconnectTimeUnit;
        this.clientExecutor = endpoint.getConfiguration().getClientExecutor();
        this.publisher = new JerseyPublisher(arg_0 -> ((ClientExecutor)this.clientExecutor).submit(arg_0), JerseyPublisher.PublisherStrategy.BLOCKING);
    }

    public void onEvent(InboundSseEvent inboundEvent) {
        this.publisher.publish((Object)inboundEvent);
    }

    public void register(Consumer<InboundSseEvent> onEvent) {
        this.subscribe(DEFAULT_SUBSCRIPTION_HANDLER, onEvent, DEFAULT_ERROR_HANDLER, () -> {});
    }

    public void register(Consumer<InboundSseEvent> onEvent, Consumer<Throwable> onError) {
        this.subscribe(DEFAULT_SUBSCRIPTION_HANDLER, onEvent, onError, () -> {});
        this.throwableConsumers.add(onError);
    }

    public void register(Consumer<InboundSseEvent> onEvent, Consumer<Throwable> onError, Runnable onComplete) {
        this.subscribe(DEFAULT_SUBSCRIPTION_HANDLER, onEvent, onError, onComplete);
        this.throwableConsumers.add(onError);
    }

    private void subscribe(final Consumer<Flow.Subscription> onSubscribe, final Consumer<InboundSseEvent> onEvent, final Consumer<Throwable> onError, final Runnable onComplete) {
        if (onSubscribe == null || onEvent == null || onError == null || onComplete == null) {
            throw new IllegalArgumentException(LocalizationMessages.PARAMS_NULL());
        }
        this.publisher.subscribe((Flow.Subscriber)new Flow.Subscriber<InboundSseEvent>(){

            @Override
            public void onSubscribe(final Flow.Subscription subscription) {
                onSubscribe.accept(new Flow.Subscription(){

                    @Override
                    public void request(long n) {
                        subscription.request(n);
                    }

                    @Override
                    public void cancel() {
                        subscription.cancel();
                    }
                });
            }

            @Override
            public void onNext(InboundSseEvent item) {
                onEvent.accept(item);
            }

            @Override
            public void onError(Throwable throwable) {
                onError.accept(throwable);
            }

            @Override
            public void onComplete() {
                onComplete.run();
            }
        });
    }

    public void open() {
        if (!this.state.compareAndSet(EventProcessor.State.READY, EventProcessor.State.OPEN)) {
            switch (this.state.get()) {
                case CLOSED: {
                    throw new IllegalStateException(LocalizationMessages.EVENT_SOURCE_ALREADY_CLOSED());
                }
                case OPEN: {
                    throw new IllegalStateException(LocalizationMessages.EVENT_SOURCE_ALREADY_CONNECTED());
                }
            }
        }
        EventProcessor processor = EventProcessor.builder((WebTarget)this.endpoint, this.state, this.clientExecutor, this::onEvent, () -> ((JerseySseEventSource)this).close()).reconnectDelay(this.reconnectDelay, this.reconnectTimeUnit).throwableConsumers(this.throwableConsumers).build();
        this.clientExecutor.submit((Runnable)processor);
        processor.awaitFirstContact();
    }

    public boolean isOpen() {
        return this.state.get() == EventProcessor.State.OPEN;
    }

    public boolean close(long timeout, TimeUnit unit) {
        if (this.state.getAndSet(EventProcessor.State.CLOSED) != EventProcessor.State.CLOSED) {
            this.publisher.close();
        }
        return true;
    }

    public static class Builder
    extends SseEventSource.Builder {
        private WebTarget endpoint;
        private long reconnectDelay = 500L;
        private TimeUnit reconnectTimeUnit = TimeUnit.MILLISECONDS;

        protected Builder target(WebTarget endpoint) {
            Objects.requireNonNull(endpoint);
            this.endpoint = endpoint;
            return this;
        }

        public Builder reconnectingEvery(long delay, TimeUnit unit) {
            this.reconnectDelay = delay;
            this.reconnectTimeUnit = unit;
            return this;
        }

        public JerseySseEventSource build() {
            if (this.endpoint instanceof JerseyWebTarget) {
                return new JerseySseEventSource((JerseyWebTarget)this.endpoint, this.reconnectDelay, this.reconnectTimeUnit);
            }
            throw new IllegalArgumentException(LocalizationMessages.UNSUPPORTED_WEBTARGET_TYPE(this.endpoint));
        }
    }
}

