/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.querydef;

import jakarta.persistence.criteria.CriteriaSelect;
import java.util.Objects;
import java.util.function.BiFunction;
import org.eclipse.persistence.internal.jpa.querydef.CriteriaQueryImpl;
import org.eclipse.persistence.internal.jpa.querydef.CriteriaSelectInternal;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReportQuery;

public class CriteriaMultiSelectImpl<T>
implements CriteriaSelect<T>,
CriteriaSelectInternal<T> {
    private final CriteriaSelectInternal<T> first;
    private final CriteriaSelectInternal<?> second;
    private final Union union;
    protected Class<T> queryType;

    public CriteriaMultiSelectImpl(CriteriaSelect<T> first, CriteriaSelect<?> second, Union union) {
        Objects.requireNonNull(first, "First component of union expression is null");
        Objects.requireNonNull(second, "Second component of union expression is null");
        this.first = (CriteriaSelectInternal)first;
        this.second = (CriteriaSelectInternal)second;
        this.union = union;
        this.queryType = this.first.getResultType();
    }

    @Override
    public Class<T> getResultType() {
        return this.queryType;
    }

    @Override
    public DatabaseQuery translate() {
        return this.translate(new BooleanValue());
    }

    private DatabaseQuery translate(BooleanValue haveTop) {
        DatabaseQuery secondQuery;
        DatabaseQuery firstQuery;
        if (this.first instanceof CriteriaQueryImpl) {
            ((CriteriaQueryImpl)this.first).isUnion();
            if (haveTop.get()) {
                firstQuery = ((CriteriaQueryImpl)this.first).transalteToReportQuery();
            } else {
                firstQuery = this.first.translate();
                haveTop.setTrue();
            }
        } else {
            firstQuery = ((CriteriaMultiSelectImpl)this.first).translate(haveTop);
        }
        if (this.second instanceof CriteriaQueryImpl) {
            ((CriteriaQueryImpl)this.second).isUnion();
            secondQuery = ((CriteriaQueryImpl)this.second).transalteToReportQuery();
        } else {
            secondQuery = ((CriteriaMultiSelectImpl)this.second).translate(haveTop);
        }
        return (DatabaseQuery)this.union.builder.apply((ReadAllQuery)firstQuery, (ReportQuery)secondQuery);
    }

    static enum Union {
        UNION((first, second) -> {
            first.union(second);
            return first;
        }),
        UNION_ALL((first, second) -> {
            first.unionAll(second);
            return first;
        }),
        INTERSECT((first, second) -> {
            first.intersect(second);
            return first;
        }),
        INTERSECT_ALL((first, second) -> {
            first.intersectAll(second);
            return first;
        }),
        EXCEPT((first, second) -> {
            first.except(second);
            return first;
        }),
        EXCEPT_ALL((first, second) -> {
            first.exceptAll(second);
            return first;
        });

        private final BiFunction<ReadAllQuery, ReportQuery, ReadAllQuery> builder;

        private Union(BiFunction<ReadAllQuery, ReportQuery, ReadAllQuery> builder) {
            this.builder = builder;
        }
    }

    private static final class BooleanValue {
        private static boolean value;

        private BooleanValue() {
            value = false;
        }

        private boolean get() {
            return value;
        }

        private void setTrue() {
            value = true;
        }
    }
}

