/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.dynamic.codegen.impl;

import java.lang.reflect.Modifier;
import java.util.Date;
import org.glassfish.pfl.basic.contain.Pair;
import org.glassfish.pfl.dynamic.codegen.impl.AssignmentStatement;
import org.glassfish.pfl.dynamic.codegen.impl.BlockStatement;
import org.glassfish.pfl.dynamic.codegen.impl.BreakStatement;
import org.glassfish.pfl.dynamic.codegen.impl.CaseBranch;
import org.glassfish.pfl.dynamic.codegen.impl.ClassGeneratorImpl;
import org.glassfish.pfl.dynamic.codegen.impl.CodegenPrinter;
import org.glassfish.pfl.dynamic.codegen.impl.DefinitionStatement;
import org.glassfish.pfl.dynamic.codegen.impl.ExpressionInternal;
import org.glassfish.pfl.dynamic.codegen.impl.IfStatement;
import org.glassfish.pfl.dynamic.codegen.impl.MethodGenerator;
import org.glassfish.pfl.dynamic.codegen.impl.NopVisitor;
import org.glassfish.pfl.dynamic.codegen.impl.ReturnStatement;
import org.glassfish.pfl.dynamic.codegen.impl.SourceExpressionVisitor;
import org.glassfish.pfl.dynamic.codegen.impl.Statement;
import org.glassfish.pfl.dynamic.codegen.impl.SwitchStatement;
import org.glassfish.pfl.dynamic.codegen.impl.ThrowStatement;
import org.glassfish.pfl.dynamic.codegen.impl.TreeWalker;
import org.glassfish.pfl.dynamic.codegen.impl.TreeWalkerContext;
import org.glassfish.pfl.dynamic.codegen.impl.TryStatement;
import org.glassfish.pfl.dynamic.codegen.impl.VariableInternal;
import org.glassfish.pfl.dynamic.codegen.impl.WhileStatement;
import org.glassfish.pfl.dynamic.codegen.spi.FieldInfo;
import org.glassfish.pfl.dynamic.codegen.spi.ImportList;
import org.glassfish.pfl.dynamic.codegen.spi.Type;
import org.glassfish.pfl.dynamic.codegen.spi.Variable;

public class SourceStatementVisitor
extends TreeWalker {
    private ImportList imports;
    CodegenPrinter pr;
    private String className;

    private String typeName(Type type) {
        if (this.imports.contains(type)) {
            return type.className();
        }
        return type.name();
    }

    public SourceStatementVisitor(TreeWalkerContext context, ImportList imports, CodegenPrinter pr) {
        super(context);
        context.push(this);
        this.imports = imports;
        this.pr = pr;
        this.className = "";
    }

    @Override
    public boolean preClassGenerator(ClassGeneratorImpl arg) {
        this.className = arg.className();
        this.pr.p("/* ").p(arg.isInterface() ? "Interface" : "Class").p(" generated by codegen source writer version 1.24.");
        this.pr.nl().p(" * Generated on ").p(new Date().toString());
        this.pr.nl().p(" */");
        this.pr.nl();
        if (arg.pkgName() != null && arg.pkgName().length() > 0) {
            this.pr.nl().p("package ").p(arg.pkgName()).p(" ;");
        }
        String lastPackage = "";
        for (Pair<String, String> data : this.imports.getInOrderList()) {
            String packageName = (String)data.first();
            String lcName = (String)data.second();
            if (!lastPackage.equals(packageName)) {
                this.pr.nl();
            }
            if (packageName.equals("")) {
                this.pr.nl().p("import " + lcName + " ;");
            } else {
                this.pr.nl().p("import " + (String)packageName + "." + lcName + " ;");
            }
            lastPackage = packageName;
        }
        this.pr.nl();
        int modifiers = arg.modifiers();
        if (arg.isInterface()) {
            modifiers &= 0xFFFFFDFF;
            modifiers &= 0xFFFFFBFF;
        }
        this.pr.nl().p(Modifier.toString(modifiers)).p(arg.isInterface() ? " interface " : " class ").p(arg.className());
        if (!arg.isInterface() && !arg.superType().equals(Type._Object())) {
            this.pr.in().nl().p("extends ").p(this.typeName(arg.superType())).out();
        }
        if (arg.impls().size() > 0) {
            this.pr.in().nl().p(arg.isInterface() ? "extends " : "implements ");
            int ctr = 0;
            for (Type type : arg.impls()) {
                if (ctr > 0) {
                    this.pr.p(", ");
                }
                this.pr.p(this.typeName(type));
                ++ctr;
            }
            this.pr.out();
        }
        this.pr.nl().p("{").in();
        if (!arg.isInterface()) {
            for (FieldInfo fld : arg.fieldInfo().values()) {
                this.pr.nl().p(Modifier.toString(fld.modifiers())).p(" ").p(this.typeName(fld.type())).p(" ").p(fld.name()).p(" ;");
            }
            this.pr.nl();
        }
        if (!arg.isInterface() && arg.constructors().size() == 0) {
            throw new IllegalStateException("All classes must define at least one constructor");
        }
        return true;
    }

    @Override
    public boolean classGeneratorBeforeFields(ClassGeneratorImpl arg) {
        return false;
    }

    @Override
    public void classGeneratorBeforeInitializer(ClassGeneratorImpl arg) {
        this.pr.nl().p("static {").in();
    }

    @Override
    public void classGeneratorBeforeMethod(ClassGeneratorImpl arg) {
        this.pr.nl();
    }

    @Override
    public void classGeneratorBeforeConstructor(ClassGeneratorImpl arg) {
        this.pr.nl();
    }

    @Override
    public void postClassGenerator(ClassGeneratorImpl arg) {
        this.pr.out().nl().p("}").nl();
    }

    @Override
    public boolean methodGeneratorBeforeArguments(MethodGenerator arg) {
        return false;
    }

    @Override
    public boolean preMethodGenerator(MethodGenerator arg) {
        ClassGeneratorImpl parent = (ClassGeneratorImpl)ClassGeneratorImpl.class.cast(arg.parent());
        if (arg.isConstructor()) {
            this.pr.nl().p(Modifier.toString(arg.modifiers())).p(" ").p(this.className).p("(");
        } else if (parent.isInterface()) {
            this.pr.nl().p(this.typeName(arg.returnType())).p(" ").p(arg.name()).p("(");
        } else {
            this.pr.nl().p(Modifier.toString(arg.modifiers())).p(" ").p(this.typeName(arg.returnType())).p(" ").p(arg.name()).p("(");
        }
        int ctr = 0;
        for (Variable var : arg.arguments()) {
            VariableInternal ivar = (VariableInternal)var;
            if (ctr > 0) {
                this.pr.p(", ");
            }
            this.pr.p(this.typeName(ivar.type())).p(" ").p(ivar.ident());
            ++ctr;
        }
        this.pr.p(")");
        boolean hasExceptions = arg.exceptions().size() > 0;
        boolean isAbstract = Modifier.isAbstract(arg.modifiers());
        if (hasExceptions) {
            this.pr.in().nl().p("throws ");
            ctr = 0;
            for (Type type : arg.exceptions()) {
                if (ctr > 0) {
                    this.pr.p(", ");
                }
                this.pr.p(this.typeName(type));
                ++ctr;
            }
        }
        if (isAbstract) {
            this.pr.p(" ;");
            if (hasExceptions) {
                this.pr.out();
            }
        } else {
            this.pr.p(" {");
            if (!hasExceptions) {
                this.pr.in();
            }
        }
        return true;
    }

    @Override
    public void postMethodGenerator(MethodGenerator arg) {
    }

    @Override
    public boolean preThrowStatement(ThrowStatement arg) {
        new SourceExpressionVisitor(this.context, this.imports);
        return true;
    }

    @Override
    public void postThrowStatement(ThrowStatement arg) {
        SourceExpressionVisitor sev = (SourceExpressionVisitor)SourceExpressionVisitor.class.cast(this.context.pop());
        this.pr.nl(arg).p("throw ").p(sev.value()).p(" ;");
    }

    @Override
    public boolean preAssignmentStatement(AssignmentStatement arg) {
        new SourceExpressionVisitor(this.context, this.imports);
        return true;
    }

    @Override
    public void assignmentStatementBeforeLeftSide(AssignmentStatement arg) {
        new SourceExpressionVisitor(this.context, this.imports);
    }

    @Override
    public void postAssignmentStatement(AssignmentStatement arg) {
        SourceExpressionVisitor var = (SourceExpressionVisitor)SourceExpressionVisitor.class.cast(this.context.pop());
        SourceExpressionVisitor expr = (SourceExpressionVisitor)SourceExpressionVisitor.class.cast(this.context.pop());
        this.pr.nl(arg).p(var.value()).p(" = ").p(expr.value()).p(" ;");
    }

    @Override
    public boolean preBlockStatement(BlockStatement arg) {
        return true;
    }

    @Override
    public void blockStatementBeforeBodyStatement(BlockStatement arg, Statement stmt) {
    }

    @Override
    public void postBlockStatement(BlockStatement arg) {
        if (arg.parent() instanceof MethodGenerator) {
            this.pr.out().nl(arg).p("}");
        } else {
            this.pr.out().nl().p("}");
        }
    }

    @Override
    public boolean preCaseBranch(CaseBranch arg) {
        this.pr.nl(arg).p("case ").p(Integer.toString(arg.label())).p(":").in();
        return true;
    }

    @Override
    public void caseBranchBeforeBodyStatement(CaseBranch arg) {
    }

    @Override
    public void postCaseBranch(CaseBranch arg) {
        this.pr.out();
    }

    @Override
    public boolean preDefinitionStatement(DefinitionStatement arg) {
        new NopVisitor(this.context);
        return this.preStatement(arg);
    }

    @Override
    public boolean definitionStatementBeforeExpr(DefinitionStatement arg) {
        this.context.pop();
        new SourceExpressionVisitor(this.context, this.imports);
        return true;
    }

    @Override
    public void postDefinitionStatement(DefinitionStatement arg) {
        SourceExpressionVisitor sev = (SourceExpressionVisitor)SourceExpressionVisitor.class.cast(this.context.pop());
        VariableInternal ivar = (VariableInternal)arg.var();
        this.pr.nl(arg).p(this.typeName(ivar.type())).p(" ").p(ivar.ident()).p(" = ").p(sev.value()).p(" ;");
    }

    @Override
    public boolean preIfStatement(IfStatement arg) {
        new SourceExpressionVisitor(this.context, this.imports);
        return true;
    }

    @Override
    public void ifStatementBeforeTruePart(IfStatement arg) {
        SourceExpressionVisitor sev = (SourceExpressionVisitor)SourceExpressionVisitor.class.cast(this.context.pop());
        this.pr.nl(arg).p("if (").p(sev.value()).p(")").p(" {").in();
    }

    @Override
    public boolean ifStatementBeforeFalsePart(IfStatement arg) {
        boolean result;
        boolean bl = result = !arg.falsePart().isEmpty();
        if (result) {
            this.pr.p(" else {").in();
        }
        return result;
    }

    @Override
    public void postIfStatement(IfStatement arg) {
        this.pr.nl();
    }

    @Override
    public boolean preBreakStatement(BreakStatement arg) {
        return true;
    }

    @Override
    public void postBreakStatement(BreakStatement arg) {
        this.pr.nl(arg).p("break ; ");
    }

    @Override
    public boolean preReturnStatement(ReturnStatement arg) {
        new SourceExpressionVisitor(this.context, this.imports);
        return true;
    }

    @Override
    public void postReturnStatement(ReturnStatement arg) {
        SourceExpressionVisitor sev = (SourceExpressionVisitor)SourceExpressionVisitor.class.cast(this.context.pop());
        this.pr.nl(arg).p("return ").p(sev.value()).p(" ;");
    }

    @Override
    public boolean preSwitchStatement(SwitchStatement arg) {
        new SourceExpressionVisitor(this.context, this.imports);
        return true;
    }

    @Override
    public boolean switchStatementBeforeCaseBranches(SwitchStatement arg) {
        SourceExpressionVisitor sev = (SourceExpressionVisitor)SourceExpressionVisitor.class.cast(this.context.pop());
        this.pr.nl(arg).p("switch (").p(sev.value()).p(") {").in();
        return true;
    }

    @Override
    public boolean switchStatementBeforeDefault(SwitchStatement arg) {
        boolean result;
        boolean bl = result = !arg.defaultCase().isEmpty();
        if (result) {
            this.pr.nl().p("default :").in();
        }
        return result;
    }

    @Override
    public void postSwitchStatement(SwitchStatement arg) {
        this.pr.out().nl().p("}");
    }

    @Override
    public boolean preTryStatement(TryStatement arg) {
        this.pr.nl().p("try {").in();
        return true;
    }

    @Override
    public void tryStatementBeforeBlock(TryStatement arg, Type type, Variable var, BlockStatement block) {
        VariableInternal ivar = (VariableInternal)var;
        this.pr.p(" catch (").p(this.typeName(type)).p(" ").p(ivar.ident()).p(") {").in();
    }

    @Override
    public boolean tryStatementBeforeFinalPart(TryStatement arg) {
        boolean result;
        boolean bl = result = !arg.finalPart().isEmpty();
        if (result) {
            this.pr.p(" finally {").in();
        }
        return result;
    }

    @Override
    public void postTryStatement(TryStatement arg) {
    }

    @Override
    public boolean preWhileStatement(WhileStatement arg) {
        new SourceExpressionVisitor(this.context, this.imports);
        return true;
    }

    @Override
    public void whileStatementBeforeBody(WhileStatement arg) {
        SourceExpressionVisitor sev = (SourceExpressionVisitor)SourceExpressionVisitor.class.cast(this.context.pop());
        this.pr.nl(arg).p("while (").p(sev.value()).p(") {").in();
    }

    @Override
    public void postWhileStatement(WhileStatement arg) {
    }

    @Override
    public boolean preExpression(ExpressionInternal arg) {
        SourceExpressionVisitor sev = new SourceExpressionVisitor(this.context, this.imports);
        arg.accept(this.context.current());
        this.context.pop();
        this.pr.nl(arg).p(sev.value()).p(" ;");
        return false;
    }

    @Override
    public void postExpression(ExpressionInternal arg) {
    }
}

