/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.io.IOException;
import org.glassfish.grizzly.http2.frames.ErrorCode;

public final class Http2StreamException
extends IOException {
    private final int streamId;
    private final ErrorCode errorCode;

    public Http2StreamException(int streamId, ErrorCode errorCode) {
        this.streamId = streamId;
        this.errorCode = errorCode;
    }

    public Http2StreamException(int streamId, ErrorCode errorCode, String description) {
        super(description);
        this.streamId = streamId;
        this.errorCode = errorCode;
    }

    public Http2StreamException(int streamId, ErrorCode errorCode, Throwable cause) {
        super(cause);
        this.streamId = streamId;
        this.errorCode = errorCode;
    }

    public Http2StreamException(int streamId, ErrorCode errorCode, String description, Throwable cause) {
        super(description, cause);
        this.streamId = streamId;
        this.errorCode = errorCode;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(this.getClass().getName()).append(" streamId=").append(this.streamId).append(" errorCode=").append((Object)this.errorCode);
        String message = this.getLocalizedMessage();
        return message != null ? sb.append(": ").append(message).toString() : sb.toString();
    }
}

