/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import jdk.incubator.http.AsyncEvent;
import jdk.incubator.http.HttpClientImpl;
import jdk.incubator.http.HttpConnection;
import jdk.incubator.http.internal.common.Utils;
import jdk.incubator.http.internal.websocket.RawChannel;

final class RawChannelImpl
implements RawChannel {
    private final HttpClientImpl client;
    private final HttpConnection connection;
    private final Object initialLock = new Object();
    private ByteBuffer initial;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RawChannelImpl(HttpClientImpl httpClientImpl, HttpConnection httpConnection, ByteBuffer byteBuffer) throws IOException {
        this.client = httpClientImpl;
        this.connection = httpConnection;
        SocketChannel socketChannel = httpConnection.channel();
        httpClientImpl.cancelRegistration(socketChannel);
        try {
            socketChannel.configureBlocking(false);
        }
        catch (IOException iOException) {
            try {
                socketChannel.close();
            }
            catch (IOException iOException2) {
                iOException.addSuppressed(iOException2);
            }
            throw iOException;
        }
        Object object = this.initialLock;
        synchronized (object) {
            this.initial = byteBuffer.hasRemaining() ? Utils.copy(byteBuffer) : Utils.EMPTY_BYTEBUFFER;
        }
    }

    @Override
    public void registerEvent(RawChannel.RawEvent rawEvent) throws IOException {
        this.client.registerEvent(new NonBlockingRawAsyncEvent(rawEvent));
    }

    @Override
    public ByteBuffer read() throws IOException {
        assert (!this.connection.channel().isBlocking());
        return this.connection.read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer initialByteBuffer() {
        Object object = this.initialLock;
        synchronized (object) {
            if (this.initial == null) {
                throw new IllegalStateException();
            }
            ByteBuffer byteBuffer = this.initial;
            this.initial = null;
            return byteBuffer;
        }
    }

    @Override
    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        return this.connection.write(byteBufferArray, n, n2);
    }

    @Override
    public void shutdownInput() throws IOException {
        this.connection.shutdownInput();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.connection.shutdownOutput();
    }

    @Override
    public void close() throws IOException {
        this.connection.close();
    }

    private class NonBlockingRawAsyncEvent
    extends AsyncEvent {
        private final RawChannel.RawEvent re;

        NonBlockingRawAsyncEvent(RawChannel.RawEvent rawEvent) {
            super(0);
            this.re = rawEvent;
        }

        @Override
        public SelectableChannel channel() {
            return RawChannelImpl.this.connection.channel();
        }

        @Override
        public int interestOps() {
            return this.re.interestOps();
        }

        @Override
        public void handle() {
            this.re.handle();
        }

        @Override
        public void abort() {
        }
    }
}

