/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.hpack;

import java.nio.ByteBuffer;
import jdk.incubator.http.internal.hpack.BinaryRepresentationWriter;
import jdk.incubator.http.internal.hpack.HeaderTable;
import jdk.incubator.http.internal.hpack.IntegerWriter;
import jdk.incubator.http.internal.hpack.StringWriter;

abstract class IndexNameValueWriter
implements BinaryRepresentationWriter {
    private final int pattern;
    private final int prefix;
    private final IntegerWriter intWriter = new IntegerWriter();
    private final StringWriter nameWriter = new StringWriter();
    private final StringWriter valueWriter = new StringWriter();
    protected boolean indexedRepresentation;
    private static final int NEW = 0;
    private static final int NAME_PART_WRITTEN = 1;
    private static final int VALUE_WRITTEN = 2;
    private int state = 0;

    protected IndexNameValueWriter(int n, int n2) {
        this.pattern = n;
        this.prefix = n2;
    }

    IndexNameValueWriter index(int n) {
        this.indexedRepresentation = true;
        this.intWriter.configure(n, this.prefix, this.pattern);
        return this;
    }

    IndexNameValueWriter name(CharSequence charSequence, boolean bl) {
        this.indexedRepresentation = false;
        this.intWriter.configure(0, this.prefix, this.pattern);
        this.nameWriter.configure(charSequence, bl);
        return this;
    }

    IndexNameValueWriter value(CharSequence charSequence, boolean bl) {
        this.valueWriter.configure(charSequence, bl);
        return this;
    }

    @Override
    public boolean write(HeaderTable headerTable, ByteBuffer byteBuffer) {
        if (this.state < 1) {
            if (this.indexedRepresentation ? !this.intWriter.write(byteBuffer) : !this.intWriter.write(byteBuffer) || !this.nameWriter.write(byteBuffer)) {
                return false;
            }
            this.state = 1;
        }
        if (this.state < 2) {
            if (!this.valueWriter.write(byteBuffer)) {
                return false;
            }
            this.state = 2;
        }
        return this.state == 2;
    }

    @Override
    public IndexNameValueWriter reset() {
        this.intWriter.reset();
        if (!this.indexedRepresentation) {
            this.nameWriter.reset();
        }
        this.valueWriter.reset();
        this.state = 0;
        return this;
    }
}

