/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.core.context;

import com.sun.tdk.signaturetest.core.context.Option;
import com.sun.tdk.signaturetest.util.CommandLineParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;

public abstract class Options {
    private final Map<Option, List<String>> values = new EnumMap<Option, List<String>>(Option.class);

    protected Options() {
    }

    protected Options getParent() {
        return null;
    }

    public boolean readOptions(String optionName, String[] args) {
        boolean parentRead = false;
        if (this.getParent() != null) {
            parentRead = this.getParent().readOptions(optionName, args);
        }
        for (Option option : this.getOptions()) {
            if (!option.accept(optionName)) continue;
            switch (option.getKind()) {
                case NONE: 
                case INSTEAD_OF_ANY: {
                    this.values.put(option, null);
                    break;
                }
                case SINGLE_OPT: 
                case SINGLE_REQ: {
                    assert (args != null);
                    assert (args.length > 0);
                    assert (!args[0].isEmpty());
                    this.values.put(option, Collections.singletonList(args[0]));
                    break;
                }
                case REQ_LIST: {
                    assert (args != null);
                    assert (args.length > 0);
                    assert (!args[0].isEmpty());
                    this.values.put(option, Arrays.asList(CommandLineParser.parseListOption(args)));
                    break;
                }
                case MANY_OPT: {
                    assert (args != null);
                    assert (args.length > 0);
                    if (!this.values.containsKey((Object)option)) {
                        this.values.put(option, new ArrayList());
                    }
                    this.values.get((Object)option).addAll(Arrays.asList(CommandLineParser.parseListOption(args)));
                }
            }
            return true;
        }
        return parentRead;
    }

    public boolean isSet(Option option) {
        assert (option != null);
        assert (option.getKind() == Option.Kind.NONE || option.getKind() == Option.Kind.INSTEAD_OF_ANY) : option.name();
        if (!this.getOptions().contains((Object)option)) {
            throw new IllegalArgumentException("Option " + option.getKey() + " is not defined in the context");
        }
        return this.values.containsKey((Object)option);
    }

    public String getValue(Option option) {
        assert (option != null);
        List<String> vals = this.getValues(option);
        if (vals == null) {
            return null;
        }
        return vals.get(0);
    }

    public List<String> getValues(Option option) {
        assert (option != null);
        if (!this.getOptions().contains((Object)option)) {
            throw new IllegalArgumentException("Option " + option.getKey() + " is not defined in the context");
        }
        if (!this.values.containsKey((Object)option)) {
            return null;
        }
        return this.values.get((Object)option);
    }

    public abstract EnumSet<Option> getOptions();
}

