/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.services;

import com.sun.javatest.Harness;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.services.LogWriter;
import com.sun.javatest.services.Service;
import com.sun.javatest.services.ServiceReader;
import com.sun.javatest.services.TestPath;
import com.sun.javatest.tool.Command;
import com.sun.javatest.tool.CommandContext;
import com.sun.javatest.tool.CommandManager;
import com.sun.javatest.util.HelpTree;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.ReadAheadIterator;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServiceManager
implements Harness.Observer {
    private Harness harness;
    private Map<String, Service> services;
    private Set<String> activeServices;
    private Set<TestPath> testServiceMap;
    private StartMode mode = ServiceCommandManager.getMode();
    private WritingThread writer;
    private WatchDog watchDog;
    private Logger commonLog;

    public ServiceManager(TestSuite ts) {
        ServiceReader reader = ts.getServiceReader();
        this.services = reader.readServices();
        this.testServiceMap = reader.readTestServiceMap();
        for (TestPath p : this.testServiceMap) {
            p.setServiceManager(this);
        }
        this.activeServices = new TreeSet<String>();
        this.writer = new WritingThread();
        this.writer.start();
        this.watchDog = new WatchDog(1000);
        this.watchDog.start();
    }

    public void setHarness(Harness h) {
        this.harness = h;
        this.harness.addObserver(this);
        this.setParameters(this.harness.getParameters());
    }

    public Harness getHarness() {
        return this.harness;
    }

    public void setParameters(Parameters p) {
        TestEnvironment env = p.getEnv();
        for (Service s : this.services.values()) {
            s.createLog(p);
            s.getProperties().setExternalProperties(env);
        }
        TestSuite ts = p.getTestSuite();
        WorkDirectory wd = p.getWorkDirectory();
        String name = "Services Common";
        try {
            this.commonLog = ts.createLog(wd, null, name);
        }
        catch (TestSuite.DuplicateLogNameFault ex) {
            try {
                this.commonLog = ts.getLog(wd, name);
            }
            catch (TestSuite.NoSuchLogFault noSuchLogFault) {
                // empty catch block
            }
        }
    }

    public void setOutputWriter(String sID, Writer out) {
        this.writer.setOutputWriter(sID, out);
    }

    public void setErrorWriter(String sID, Writer err) {
        this.writer.setErrorWriter(sID, err);
    }

    public Map<String, Service> getAllServices() {
        return new HashMap<String, Service>(this.services);
    }

    public Set<String> getActiveServices() {
        return new TreeSet<String>(this.activeServices);
    }

    public void startService(String sID) {
        Service s = this.services.get(sID);
        try {
            if (s.isAlive()) {
                return;
            }
            if (!s.start()) {
                String msg = "Service " + sID + " was not started";
                this.commonLog.log(Level.WARNING, msg);
                for (Observer o : this.watchDog.getObservers()) {
                    o.handleError(sID, new Service.ServiceError(msg));
                }
            } else {
                String msg = "Service " + sID + " was started";
                this.commonLog.log(Level.INFO, msg);
                this.activeServices.add(sID);
                this.writer.add(s);
            }
        }
        catch (Service.NotConnectedException ex) {
            String msg = "Service " + sID + " was not started because of" + " connection failure\n";
            msg = msg + ex.getMessage();
            this.commonLog.log(Level.WARNING, msg);
            for (Observer o : this.watchDog.getObservers()) {
                o.handleNotConnected(sID, ex);
            }
        }
        catch (Service.ServiceError ex) {
            String msg = "Service " + sID + " was not started because of" + " service error\n";
            msg = msg + ex.getMessage();
            this.commonLog.log(Level.WARNING, msg);
            for (Observer o : this.watchDog.getObservers()) {
                o.handleError(sID, ex);
            }
        }
        this.watchDog.refreshServices();
    }

    public void stopService(String sID) {
        if (this.stopService0(sID)) {
            this.activeServices.remove(sID);
        }
    }

    private boolean stopService0(String sID) {
        try {
            Service serv = this.services.get(sID);
            if (!serv.stop()) {
                String msg = "Service " + sID + " was not stopped";
                this.commonLog.log(Level.WARNING, msg);
                return false;
            }
            String msg = "Service " + sID + " was stopped";
            this.commonLog.log(Level.INFO, msg);
            this.writer.remove(sID);
            this.watchDog.refreshServices();
            return true;
        }
        catch (Service.NotConnectedException ex) {
            String msg = "Service " + sID + " was not stopped because of" + " connection failure\n";
            msg = msg + ex.getMessage();
            this.commonLog.log(Level.WARNING, msg);
        }
        catch (Service.ServiceError ex) {
            String msg = "Service " + sID + " was not stopped because of" + " service error\n";
            msg = msg + ex.getMessage();
            this.commonLog.log(Level.WARNING, msg);
        }
        return false;
    }

    @Override
    public void startingTestRun(Parameters params) {
        if (this.mode == StartMode.UP_FRONT) {
            Set<Object> active = new TreeSet();
            try {
                ReadAheadIterator iter = this.harness.getTestsIterator(null);
                active = this.selectActiveServices(iter);
            }
            catch (Harness.Fault f) {
                this.commonLog.log(Level.SEVERE, f.getMessage());
                return;
            }
            for (String string : active) {
                this.startService(string);
            }
        }
    }

    @Override
    public synchronized void startingTest(TestResult tr) {
        if (this.mode == StartMode.LAZY) {
            try {
                TestDescription td = tr.getDescription();
                for (TestPath p : this.testServiceMap) {
                    if (!p.matches(td)) continue;
                    for (String sID : p.getServices()) {
                        boolean isAlive = true;
                        try {
                            isAlive = this.services.get(sID).isAlive();
                        }
                        catch (Service.NotConnectedException ex) {
                            isAlive = false;
                        }
                        catch (Service.ServiceError ex) {
                            isAlive = false;
                        }
                        if (this.activeServices.contains(sID) && isAlive) continue;
                        this.startService(sID);
                    }
                }
            }
            catch (TestResult.Fault fault) {
                // empty catch block
            }
        }
    }

    @Override
    public void finishedTest(TestResult tr) {
    }

    @Override
    public void stoppingTestRun() {
        this.stopServices();
    }

    @Override
    public void finishedTesting() {
        this.stopServices();
    }

    @Override
    public void finishedTestRun(boolean allOK) {
    }

    @Override
    public void error(String msg) {
    }

    public void setStartMode(StartMode mode) {
        this.mode = mode;
    }

    private Set<String> selectActiveServices(Iterator iter) {
        TestResult tr;
        TreeSet<String> active = new TreeSet<String>();
        HashSet<TestPath> copy = new HashSet<TestPath>(this.testServiceMap);
        while (!copy.isEmpty() && active.size() < this.services.size() && (tr = (TestResult)iter.next()) != null) {
            try {
                TestDescription td = tr.getDescription();
                HashSet<TestPath> toRemove = new HashSet<TestPath>();
                for (TestPath p : copy) {
                    if (!p.matches(td)) continue;
                    for (String sId : p.getServices()) {
                        active.add(sId);
                    }
                    toRemove.add(p);
                }
                copy.removeAll(toRemove);
            }
            catch (TestResult.Fault fault) {}
        }
        return active;
    }

    private synchronized void stopServices() {
        TreeSet<String> toRemove = new TreeSet<String>();
        for (String s : this.activeServices) {
            if (!this.stopService0(s)) continue;
            toRemove.add(s);
        }
        this.activeServices.removeAll(toRemove);
        if (this.harness != null) {
            this.harness.removeObserver(this);
            this.harness = null;
        }
        this.writer.finish();
    }

    public void addObserver(Observer o) {
        if (this.watchDog != null) {
            this.watchDog.addObserver(o);
        }
    }

    public void removeObserver(Observer o) {
        if (this.watchDog != null) {
            this.watchDog.removeObserver(o);
        }
    }

    public static class ServiceCommandManager
    extends CommandManager {
        private static StartMode mode = StartMode.UP_FRONT;
        private I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(this.getClass());

        public static StartMode getMode() {
            return mode;
        }

        @Override
        public HelpTree.Node getHelp() {
            String[] cmds = new String[]{ServiceStartCommand.getName()};
            return new HelpTree.Node(this.i18n, "cmds", cmds);
        }

        @Override
        public boolean parseCommand(String cmd, ListIterator argIter, CommandContext ctx) throws Command.Fault {
            if (ServiceCommandManager.isMatch(cmd, ServiceStartCommand.getName())) {
                if (!argIter.hasNext()) {
                    return false;
                }
                String val = (String)argIter.next();
                for (StartMode m : StartMode.values()) {
                    if (!m.getKey().equalsIgnoreCase(val)) continue;
                    mode = m;
                    return true;
                }
                return false;
            }
            return false;
        }

        private static class ServiceStartCommand
        extends Command {
            static String getName() {
                return "startServices";
            }

            ServiceStartCommand() {
                super(ServiceStartCommand.getName());
            }

            @Override
            public void run(CommandContext ctx) throws Command.Fault {
            }
        }
    }

    public static interface Observer {
        public void handleAlive(String var1, boolean var2);

        public void handleNotConnected(String var1, Service.NotConnectedException var2);

        public void handleError(String var1, Service.ServiceError var2);
    }

    private class WatchDog
    extends Thread {
        private boolean stop;
        private Set<Observer> observers = new HashSet<Observer>();
        private int pause;
        private Set<String> active;
        private Object sync;

        public WatchDog(int timeout) {
            this.pause = timeout;
            this.setDaemon(true);
            this.active = ServiceManager.this.getActiveServices();
            this.sync = new Object();
        }

        public void addObserver(Observer o) {
            this.observers.add(o);
        }

        public void removeObserver(Observer o) {
            this.observers.remove(o);
        }

        public Set<Observer> getObservers() {
            return this.observers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refreshServices() {
            this.active = ServiceManager.this.getActiveServices();
            Object object = this.sync;
            synchronized (object) {
                this.sync.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.stop = false;
            boolean isAlive = true;
            while (true) {
                Object object = this.sync;
                synchronized (object) {
                    if (this.active.size() == 0) {
                        try {
                            this.sync.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                for (String sID : this.active) {
                    try {
                        isAlive = ((Service)ServiceManager.this.services.get(sID)).isAlive();
                        for (Observer o : this.observers) {
                            o.handleAlive(sID, isAlive);
                        }
                    }
                    catch (Service.NotConnectedException ex) {
                        for (Observer o : this.observers) {
                            o.handleNotConnected(sID, ex);
                        }
                    }
                    catch (Service.ServiceError ex) {
                        for (Observer o : this.observers) {
                            o.handleError(sID, ex);
                        }
                    }
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    private class WritingThread
    extends Thread {
        private Map<String, Writer> outs = new HashMap<String, Writer>();
        private Map<String, Writer> errs = new HashMap<String, Writer>();
        private Map<String, InputStreamReader> sOuts = new HashMap<String, InputStreamReader>();
        private Map<String, InputStreamReader> sErrs = new HashMap<String, InputStreamReader>();

        public WritingThread() {
            this.setDaemon(true);
        }

        public synchronized void add(Service s) {
            String sID = "";
            try {
                sID = s.getId();
                Writer w = this.outs.get(sID);
                if (w == null) {
                    this.outs.put(sID, new LogWriter(s.getLog(), Level.ALL));
                }
                InputStreamReader or = new InputStreamReader(s.getInputStream());
                this.sOuts.put(sID, or);
                w = this.errs.get(sID);
                if (w == null) {
                    this.errs.put(sID, new LogWriter(s.getLog(), Level.SEVERE));
                }
                InputStreamReader er = new InputStreamReader(s.getErrorStream());
                this.sErrs.put(sID, er);
                this.notifyAll();
            }
            catch (Service.NotConnectedException ex) {
                String msg = "Service :" + sID;
                msg = msg + "Error occurred when trying to access service streams.\n";
                msg = msg + ex.getMessage();
                ServiceManager.this.commonLog.log(Level.WARNING, msg);
            }
        }

        public synchronized void remove(String sID) {
            try {
                InputStreamReader r;
                Writer w = this.outs.get(sID);
                if (w != null) {
                    w.flush();
                }
                if ((r = this.sOuts.get(sID)) != null) {
                    r.close();
                }
                this.sOuts.remove(sID);
                w = this.errs.get(sID);
                if (w != null) {
                    w.flush();
                }
                if ((r = this.sErrs.get(sID)) != null) {
                    r.close();
                }
                this.sErrs.remove(sID);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public synchronized void setOutputWriter(String sID, Writer out) {
            if (this.outs == null) {
                this.outs = new HashMap<String, Writer>();
            }
            this.outs.put(sID, out);
        }

        public synchronized void setErrorWriter(String sID, Writer err) {
            if (this.errs == null) {
                this.errs = new HashMap<String, Writer>();
            }
            this.errs.put(sID, err);
        }

        synchronized void finish() {
            for (String sID : this.outs.keySet()) {
                this.remove(sID);
            }
            for (String sID : this.errs.keySet()) {
                this.remove(sID);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                WritingThread writingThread = this;
                synchronized (writingThread) {
                    if (this.sOuts.size() == 0 && this.sErrs.size() == 0) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                this.write(this.outs, this.sOuts);
                this.write(this.errs, this.sErrs);
                try {
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void write(Map<String, Writer> wm, Map<String, InputStreamReader> rm) {
            String[] idCopy;
            char[] buf = new char[1000];
            LinkedList<String> toRemove = new LinkedList<String>();
            WritingThread writingThread = this;
            synchronized (writingThread) {
                idCopy = rm.keySet().toArray(new String[rm.keySet().size()]);
            }
            for (String sID : idCopy) {
                InputStreamReader r = rm.get(sID);
                Writer w = wm.get(sID);
                if (r == null || w == null) continue;
                int n = 0;
                try {
                    n = r.read(buf);
                    if (n > 0) {
                        w.write(buf, 0, n);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (n != -1) continue;
                toRemove.add(sID);
            }
            for (String sID : toRemove) {
                WritingThread writingThread2 = this;
                synchronized (writingThread2) {
                    InputStreamReader r = rm.remove(sID);
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    public static enum StartMode {
        LAZY("lazy"),
        UP_FRONT("up_front"),
        MANUALLY("manually");

        private String key;

        private StartMode(String s) {
            this.key = s;
        }

        public String getKey() {
            return this.key;
        }
    }
}

