/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */

package com.sun.ts.tests.jsonb.customizedmapping.adapters.model.adapter;

import javax.json.bind.adapter.JsonbAdapter;

import com.sun.ts.tests.jsonb.customizedmapping.adapters.model.Animal;

import java.util.ArrayList;
import java.util.List;

public class AnimalListAdapter implements JsonbAdapter<List<Animal>, List<AnimalJson>> {
    private AnimalAdapter animalAdapter = new AnimalAdapter();

    @Override
    public List<AnimalJson> adaptToJson(List<Animal> animals) throws Exception {
        List<AnimalJson> adapted = new ArrayList<>();
        for (Animal animal : animals) {
            adapted.add(animalAdapter.adaptToJson(animal));
        }
        return adapted;
    }

    @Override
    public List<Animal> adaptFromJson(List<AnimalJson> adapted) throws Exception {
        List<Animal> animals = new ArrayList<>();
        for (AnimalJson animal : adapted) {
            animals.add(animalAdapter.adaptFromJson(animal));
        }
        return animals;
    }
}
