/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */

package com.sun.ts.tests.jsonb.defaultmapping.specifictypes.model;

import java.util.Arrays;
import java.util.Optional;

import com.sun.ts.tests.jsonb.TypeContainer;

public class OptionalArrayContainer implements TypeContainer<Optional<String>[]> {
    private Optional<String>[] instance;

    @Override
    public Optional<String>[] getInstance() {
        return instance;
    }

    @Override
    public void setInstance(Optional<String>[] instance) {
        this.instance = instance;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof OptionalArrayContainer)) return false;

        OptionalArrayContainer that = (OptionalArrayContainer) o;

        return Arrays.equals(instance, that.instance);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(instance);
    }
}
