/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */

package com.sun.ts.tests.jsonb.defaultmapping.specifictypes.model;

import com.sun.ts.tests.jsonb.TypeContainer;

import java.util.OptionalLong;

public class OptionalLongContainer implements TypeContainer<OptionalLong> {
    private OptionalLong instance;

    @Override
    public OptionalLong getInstance() {
        return instance;
    }

    @Override
    public void setInstance(OptionalLong instance) {
        this.instance = instance;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof OptionalLongContainer)) return false;

        OptionalLongContainer that = (OptionalLongContainer) o;

        return instance != null ? instance.equals(that.instance) : that.instance == null;
    }

    @Override
    public int hashCode() {
        return instance != null ? instance.hashCode() : 0;
    }
}
