/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: MyJsonWriterFactory.java 69847 2013-02-06 13:53:54Z adf $
 */

package com.sun.ts.tests.jsonp.provider;

import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.*;

import javax.json.*;
import java.io.*;
import java.nio.charset.Charset;
import java.util.*;

/*
 * MyJsonWriterFactory is a Json Test WriterFactory used by the pluggability tests
 * to test the Json SPI layer. This parser tracks that the proper callback
 * methods are invoked within the parser when Json API methods are called.
 */

public class MyJsonWriterFactory implements JsonWriterFactory {
    private OutputStream out = null;
    private Writer writer = null;
    private Charset charset = null;
    private Map<String, ?> config = null;

    private void dumpInstanceVars() {
	TestUtil.logTrace("writer="+writer);
	TestUtil.logTrace("out="+out);
	TestUtil.logTrace("charset="+charset);
	TestUtil.logTrace("config="+config);
    }

    // call methods
    private static StringBuilder calls = new StringBuilder();

    public static String getCalls() {
	return calls.toString();
    }

    public static void clearCalls() {
	calls.delete(0, calls.length());
    }

    private static void addCalls(String s) {
	calls.append(s);
    }

    public MyJsonWriterFactory(Map<String, ?> config) {
        this.config = config;
    }

    public Map<String, ?> getConfigInUse() {
	TestUtil.logTrace("public Map<String, ?> getConfigInUse()");
	addCalls("public Map<String, ?> getConfigInUse()");
	return config;
    }

    public JsonWriter createWriter(OutputStream out) {
	TestUtil.logTrace("public JsonWriter createWriter(OutputStream)");
	addCalls("public JsonWriter createWriter(OutputStream)");
	this.out = out;
	return null;
    }

    public JsonWriter createWriter(OutputStream out, Charset charset) {
	TestUtil.logTrace("public JsonWriter createWriter(OutputStream, Charset)");
	addCalls("public JsonWriter createWriter(OutputStream, Charset)");
	this.out = out;
	this.charset = charset;
	return null;
    }

    public JsonWriter createWriter(Writer writer) {
	TestUtil.logTrace("public JsonWriter createWriter(Writer)");
	addCalls("public JsonWriter createWriter(Writer)");
	this.writer = writer;
	return null;
    }
}
