/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.operations;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCache;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.op.IgnoreOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.decorators.GitLightweightDecorator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class IgnoreOperationUI {
    private static final int WARNING_THRESHOLD = 500;
    private final Collection<IPath> paths;

    public IgnoreOperationUI(Collection<IPath> paths) {
        this.paths = paths;
    }

    public void run() {
        if (this.paths.size() > 500) {
            Shell shell = PlatformUI.getWorkbench().getModalDialogShellProvider().getShell();
            if (!MessageDialog.openQuestion((Shell)shell, (String)MessageFormat.format(UIText.IgnoreActionHandler_manyFilesToBeIgnoredTitle, Integer.toString(this.paths.size())), (String)UIText.IgnoreActionHandler_manyFilesToBeIgnoredQuestion)) {
                return;
            }
        }
        final IgnoreOperation operation = new IgnoreOperation(this.paths);
        String jobname = UIText.IgnoreActionHandler_addToGitignore;
        WorkspaceJob job = new WorkspaceJob(jobname){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    try {
                        operation.execute(monitor);
                    }
                    catch (CoreException e) {
                        IStatus iStatus = Activator.createErrorStatus(e.getStatus().getMessage(), e);
                        monitor.done();
                        return iStatus;
                    }
                    if (operation.isGitignoreOutsideWSChanged()) {
                        IgnoreOperationUI.this.refresh();
                    }
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.setUser(true);
        job.setRule(operation.getSchedulingRule());
        job.schedule();
    }

    private void refresh() {
        Map pathsByRepository = ResourceUtil.splitPathsByRepository(this.paths);
        for (Repository repository : pathsByRepository.keySet()) {
            IndexDiffCacheEntry entry = IndexDiffCache.INSTANCE.getIndexDiffCacheEntry(repository);
            if (entry == null) continue;
            entry.refresh();
        }
        GitLightweightDecorator.refresh();
    }
}

