/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.core.ui;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class LabelFakeFieldEditor
extends FieldEditor {
    protected String oldValue;
    Label labelField;
    String labelValue;
    private String errorMessage;

    protected LabelFakeFieldEditor() {
    }

    public LabelFakeFieldEditor(String value, String labelText, Composite parent) {
        this.init("no_name", labelText);
        this.labelValue = value;
        this.errorMessage = JFaceResources.getString((String)"StringFieldEditor.errorMessage");
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.labelField.getLayoutData();
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = gd.horizontalSpan == 1;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelControl(parent);
        this.labelField = this.getTextControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns - 1;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.labelField.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        this.setStringValue(this.labelValue);
    }

    protected void doLoadDefault() {
        this.setStringValue(this.labelValue);
    }

    protected void doStore() {
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getNumberOfControls() {
        return 2;
    }

    public String getStringValue() {
        if (this.labelField != null) {
            return this.labelField.getText();
        }
        return "";
    }

    protected Label getTextControl() {
        return this.labelField;
    }

    public Label getTextControl(Composite parent) {
        if (this.labelField == null) {
            this.labelField = new Label(parent, 2052);
            this.labelField.setFont(parent.getFont());
            this.labelField.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    LabelFakeFieldEditor.this.labelField = null;
                }
            });
        } else {
            this.checkParent((Control)this.labelField, parent);
        }
        return this.labelField;
    }

    public void setErrorMessage(String message) {
        this.errorMessage = message;
    }

    public void setFocus() {
        if (this.labelField != null) {
            this.labelField.setFocus();
        }
    }

    public void setStringValue(String value) {
        if (this.labelField != null) {
            if (value == null) {
                value = "";
            }
            this.oldValue = this.labelField.getText();
            if (!this.oldValue.equals(value)) {
                this.labelField.setText(value);
                this.valueChanged();
            }
        }
    }

    public void showErrorMessage() {
        this.showErrorMessage(this.errorMessage);
    }

    protected void valueChanged() {
        this.setPresentsDefaultValue(false);
        this.refreshValidState();
        String newValue = this.labelField.getText();
        if (!newValue.equals(this.oldValue)) {
            this.fireValueChanged("field_editor_value", this.oldValue, newValue);
            this.oldValue = newValue;
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getTextControl(parent).setEnabled(enabled);
    }
}

