/*
 * Decompiled with CFR 0.152.
 */
package com.github.javabdd;

import com.github.javabdd.BDD;
import com.github.javabdd.BDDDomain;
import com.github.javabdd.BDDException;
import com.github.javabdd.BDDFactory;
import java.math.BigInteger;

public abstract class BDDBitVector {
    protected BDD[] bitvec;

    protected BDDBitVector(int bitnum) {
        this.bitvec = new BDD[bitnum];
    }

    protected void initialize(boolean isTrue) {
        BDDFactory bdd = this.getFactory();
        for (int n = 0; n < this.bitvec.length; ++n) {
            this.bitvec[n] = isTrue ? bdd.one() : bdd.zero();
        }
    }

    protected void initialize(int val) {
        BDDFactory bdd = this.getFactory();
        for (int n = 0; n < this.bitvec.length; ++n) {
            this.bitvec[n] = (val & 1) != 0 ? bdd.one() : bdd.zero();
            val >>= 1;
        }
    }

    protected void initialize(long val) {
        BDDFactory bdd = this.getFactory();
        for (int n = 0; n < this.bitvec.length; ++n) {
            this.bitvec[n] = (val & 1L) != 0L ? bdd.one() : bdd.zero();
            val >>= 1;
        }
    }

    protected void initialize(BigInteger val) {
        BDDFactory bdd = this.getFactory();
        for (int n = 0; n < this.bitvec.length; ++n) {
            this.bitvec[n] = val.testBit(0) ? bdd.one() : bdd.zero();
            val = val.shiftRight(1);
        }
    }

    protected void initialize(int offset, int step) {
        BDDFactory bdd = this.getFactory();
        for (int n = 0; n < this.bitvec.length; ++n) {
            this.bitvec[n] = bdd.ithVar(offset + n * step);
        }
    }

    protected void initialize(BDDDomain d) {
        this.initialize(d.vars());
    }

    protected void initialize(int[] var) {
        BDDFactory bdd = this.getFactory();
        for (int n = 0; n < this.bitvec.length; ++n) {
            this.bitvec[n] = bdd.ithVar(var[n]);
        }
    }

    public abstract BDDFactory getFactory();

    public BDDBitVector copy() {
        BDDFactory bdd = this.getFactory();
        BDDBitVector dst = bdd.createBitVector(this.bitvec.length);
        for (int n = 0; n < this.bitvec.length; ++n) {
            dst.bitvec[n] = this.bitvec[n].id();
        }
        return dst;
    }

    public BDDBitVector coerce(int bitnum) {
        int n;
        BDDFactory bdd = this.getFactory();
        BDDBitVector dst = bdd.createBitVector(bitnum);
        int minnum = Math.min(bitnum, this.bitvec.length);
        for (n = 0; n < minnum; ++n) {
            dst.bitvec[n] = this.bitvec[n].id();
        }
        while (n < minnum) {
            dst.bitvec[n] = bdd.zero();
            ++n;
        }
        return dst;
    }

    public boolean isConst() {
        for (int n = 0; n < this.bitvec.length; ++n) {
            BDD b = this.bitvec[n];
            if (b.isOne() || b.isZero()) continue;
            return false;
        }
        return true;
    }

    public int val() {
        int val = 0;
        for (int n = this.bitvec.length - 1; n >= 0; --n) {
            if (this.bitvec[n].isOne()) {
                val = val << 1 | 1;
                continue;
            }
            if (this.bitvec[n].isZero()) {
                val <<= 1;
                continue;
            }
            return 0;
        }
        return val;
    }

    public void free() {
        for (int n = 0; n < this.bitvec.length; ++n) {
            this.bitvec[n].free();
        }
        this.bitvec = null;
    }

    public BDDBitVector map2(BDDBitVector that, BDDFactory.BDDOp op) {
        if (this.bitvec.length != that.bitvec.length) {
            throw new BDDException();
        }
        BDDFactory bdd = this.getFactory();
        BDDBitVector res = bdd.createBitVector(this.bitvec.length);
        for (int n = 0; n < this.bitvec.length; ++n) {
            res.bitvec[n] = this.bitvec[n].apply(that.bitvec[n], op);
        }
        return res;
    }

    public BDDBitVector add(BDDBitVector that) {
        if (this.bitvec.length != that.bitvec.length) {
            throw new BDDException();
        }
        BDDFactory bdd = this.getFactory();
        BDD c = bdd.zero();
        BDDBitVector res = bdd.createBitVector(this.bitvec.length);
        for (int n = 0; n < res.bitvec.length; ++n) {
            res.bitvec[n] = this.bitvec[n].xor(that.bitvec[n]);
            res.bitvec[n].xorWith(c.id());
            BDD tmp1 = this.bitvec[n].or(that.bitvec[n]);
            tmp1.andWith(c);
            BDD tmp2 = this.bitvec[n].and(that.bitvec[n]);
            tmp2.orWith(tmp1);
            c = tmp2;
        }
        c.free();
        return res;
    }

    public BDDBitVector sub(BDDBitVector that) {
        if (this.bitvec.length != that.bitvec.length) {
            throw new BDDException();
        }
        BDDFactory bdd = this.getFactory();
        BDD c = bdd.zero();
        BDDBitVector res = bdd.createBitVector(this.bitvec.length);
        for (int n = 0; n < res.bitvec.length; ++n) {
            res.bitvec[n] = this.bitvec[n].xor(that.bitvec[n]);
            res.bitvec[n].xorWith(c.id());
            BDD tmp1 = that.bitvec[n].or(c);
            BDD tmp2 = this.bitvec[n].apply(tmp1, BDDFactory.less);
            tmp1.free();
            tmp1 = this.bitvec[n].and(that.bitvec[n]);
            tmp1.andWith(c);
            tmp1.orWith(tmp2);
            c = tmp1;
        }
        c.free();
        return res;
    }

    BDD lte(BDDBitVector r) {
        if (this.bitvec.length != r.bitvec.length) {
            throw new BDDException();
        }
        BDDFactory bdd = this.getFactory();
        BDD p = bdd.one();
        for (int n = 0; n < this.bitvec.length; ++n) {
            BDD tmp1 = this.bitvec[n].apply(r.bitvec[n], BDDFactory.less);
            BDD tmp2 = this.bitvec[n].apply(r.bitvec[n], BDDFactory.biimp);
            tmp2.andWith(p);
            tmp1.orWith(tmp2);
            p = tmp1;
        }
        return p;
    }

    static void div_rec(BDDBitVector divisor, BDDBitVector remainder, BDDBitVector result, int step) {
        BDD isSmaller = divisor.lte(remainder);
        BDDBitVector newResult = result.shl(1, isSmaller);
        BDDFactory bdd = divisor.getFactory();
        BDDBitVector zero = bdd.buildVector(divisor.bitvec.length, false);
        BDDBitVector sub = bdd.buildVector(divisor.bitvec.length, false);
        for (int n = 0; n < divisor.bitvec.length; ++n) {
            sub.bitvec[n] = isSmaller.ite(divisor.bitvec[n], zero.bitvec[n]);
        }
        BDDBitVector tmp = remainder.sub(sub);
        BDDBitVector newRemainder = tmp.shl(1, result.bitvec[divisor.bitvec.length - 1]);
        if (step > 1) {
            BDDBitVector.div_rec(divisor, newRemainder, newResult, step - 1);
        }
        tmp.free();
        sub.free();
        zero.free();
        isSmaller.free();
        result.replaceWith(newResult);
        remainder.replaceWith(newRemainder);
    }

    public void replaceWith(BDDBitVector that) {
        if (this.bitvec.length != that.bitvec.length) {
            throw new BDDException();
        }
        this.free();
        this.bitvec = that.bitvec;
        that.bitvec = null;
    }

    public BDDBitVector shl(int pos, BDD c) {
        int n;
        int minnum = Math.min(this.bitvec.length, pos);
        if (minnum < 0) {
            throw new BDDException();
        }
        BDDFactory bdd = this.getFactory();
        BDDBitVector res = bdd.createBitVector(this.bitvec.length);
        for (n = 0; n < minnum; ++n) {
            res.bitvec[n] = c.id();
        }
        for (n = minnum; n < this.bitvec.length; ++n) {
            res.bitvec[n] = this.bitvec[n - pos].id();
        }
        return res;
    }

    BDDBitVector shr(int pos, BDD c) {
        int n;
        int maxnum = Math.max(0, this.bitvec.length - pos);
        if (maxnum < 0) {
            throw new BDDException();
        }
        BDDFactory bdd = this.getFactory();
        BDDBitVector res = bdd.createBitVector(this.bitvec.length);
        for (n = maxnum; n < this.bitvec.length; ++n) {
            res.bitvec[n] = c.id();
        }
        for (n = 0; n < maxnum; ++n) {
            res.bitvec[n] = this.bitvec[n + pos].id();
        }
        return res;
    }

    public BDDBitVector divmod(long c, boolean which) {
        if (c <= 0L) {
            throw new BDDException();
        }
        BDDFactory bdd = this.getFactory();
        BDDBitVector divisor = bdd.constantVector(this.bitvec.length, c);
        BDDBitVector tmp = bdd.buildVector(this.bitvec.length, false);
        BDDBitVector tmpremainder = tmp.shl(1, this.bitvec[this.bitvec.length - 1]);
        BDDBitVector result = this.shl(1, bdd.zero());
        BDDBitVector.div_rec(divisor, tmpremainder, result, divisor.bitvec.length);
        BDDBitVector remainder = tmpremainder.shr(1, bdd.zero());
        tmp.free();
        tmpremainder.free();
        divisor.free();
        if (which) {
            remainder.free();
            return result;
        }
        result.free();
        return remainder;
    }

    public int size() {
        return this.bitvec.length;
    }

    public BDD getBit(int n) {
        return this.bitvec[n];
    }
}

