/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth;

import java.util.List;
import org.eclipse.escet.cif.datasynth.settings.FixedPointComputation;
import org.eclipse.escet.cif.datasynth.settings.FixedPointComputationsOrder;
import org.eclipse.escet.common.box.GridBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Stopwatch;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.output.DebugNormalOutput;

public class CifDataSynthesisTiming {
    public Stopwatch total = new Stopwatch();
    public Stopwatch inputRead = new Stopwatch();
    public Stopwatch inputPreProcess = new Stopwatch();
    public Stopwatch inputConvert = new Stopwatch();
    public Stopwatch preSynth = new Stopwatch();
    public Stopwatch main = new Stopwatch();
    public Stopwatch mainNonBlock = new Stopwatch();
    public Stopwatch mainReachReqs = new Stopwatch();
    public Stopwatch mainCtrl = new Stopwatch();
    public Stopwatch mainReach = new Stopwatch();
    public Stopwatch postSynth = new Stopwatch();
    public Stopwatch outputConvert = new Stopwatch();
    public Stopwatch outputWrite = new Stopwatch();

    public void print(int indentAmount, DebugNormalOutput debugOutput, DebugNormalOutput normalOutput, FixedPointComputationsOrder fixedPointOrder) {
        String indent = Strings.spaces((int)indentAmount);
        List prefixes = Lists.list();
        List stopwatches = Lists.list();
        if (this.total.hasMeasured()) {
            prefixes.add("Total");
            stopwatches.add(this.total);
        }
        if (this.inputRead.hasMeasured()) {
            prefixes.add(indent + "Read input model");
            stopwatches.add(this.inputRead);
        }
        if (this.inputPreProcess.hasMeasured()) {
            prefixes.add(indent + "Preprocess and check input model");
            stopwatches.add(this.inputPreProcess);
        }
        if (this.inputConvert.hasMeasured()) {
            prefixes.add(indent + "Convert input model");
            stopwatches.add(this.inputConvert);
        }
        if (this.preSynth.hasMeasured()) {
            prefixes.add(indent + "Pre synthesis");
            stopwatches.add(this.preSynth);
        }
        if (this.main.hasMeasured()) {
            prefixes.add(indent + "Main synthesis loop");
            stopwatches.add(this.main);
        }
        for (FixedPointComputation fixedPointComputation : fixedPointOrder.computations) {
            switch (fixedPointComputation) {
                case CTRL: {
                    if (!this.mainCtrl.hasMeasured()) break;
                    prefixes.add(indent + indent + "Controllable states");
                    stopwatches.add(this.mainCtrl);
                    break;
                }
                case NONBLOCK: {
                    if (!this.mainNonBlock.hasMeasured()) break;
                    prefixes.add(indent + indent + "Non-blocking states");
                    stopwatches.add(this.mainNonBlock);
                    break;
                }
                case REACH: {
                    if (!this.mainReach.hasMeasured()) break;
                    prefixes.add(indent + indent + "Reachable states");
                    stopwatches.add(this.mainReach);
                    break;
                }
                case REACH_REQS: {
                    if (!this.mainReachReqs.hasMeasured()) break;
                    prefixes.add(indent + indent + "Reachability requirements");
                    stopwatches.add(this.mainReachReqs);
                }
            }
        }
        if (this.postSynth.hasMeasured()) {
            prefixes.add(indent + "Post synthesis");
            stopwatches.add(this.postSynth);
        }
        if (this.outputConvert.hasMeasured()) {
            prefixes.add(indent + "Convert output model");
            stopwatches.add(this.outputConvert);
        }
        if (this.outputWrite.hasMeasured()) {
            prefixes.add(indent + "Write output model");
            stopwatches.add(this.outputWrite);
        }
        Assert.check((prefixes.size() == stopwatches.size() ? 1 : 0) != 0);
        String[] measurements = new String[stopwatches.size()];
        int i = 0;
        while (i < stopwatches.size()) {
            Assert.check((!((Stopwatch)stopwatches.get(i)).isRunning() ? 1 : 0) != 0);
            measurements[i] = Strings.fmt((String)"%,.0f ms", (Object[])new Object[]{((Stopwatch)stopwatches.get(i)).getDurationMillis()});
            ++i;
        }
        GridBox grid = new GridBox(measurements.length + 2, 2, 0, 2);
        grid.set(0, 0, "Timing measurement");
        grid.set(0, 1, "Duration");
        int i2 = 0;
        while (i2 < prefixes.size()) {
            grid.set(i2 + 2, 0, (String)prefixes.get(i2));
            grid.set(i2 + 2, 1, measurements[i2]);
            ++i2;
        }
        GridBox.GridBoxLayout layout = grid.computeLayout();
        int i3 = 0;
        while (i3 < layout.numCols) {
            String bar = Strings.duplicate((String)"-", (int)layout.widths[i3]);
            grid.set(1, i3, bar);
            ++i3;
        }
        int timingColWidth = layout.widths[1];
        int i4 = 0;
        while (i4 < measurements.length) {
            String txt = measurements[i4];
            String empty = Strings.spaces((int)(timingColWidth - txt.length()));
            grid.set(i4 + 2, 1, empty + txt);
            ++i4;
        }
        debugOutput.line();
        for (String line : grid.getLines()) {
            normalOutput.line(line);
        }
    }
}

