/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator;

import java.util.Deque;
import java.util.LinkedList;
import org.eclipse.escet.cif.simulator.options.HistorySizeOption;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeState;
import org.eclipse.escet.common.java.Assert;

public class CifSimulatorHistory {
    private final RuntimeState initialState;
    private Deque<RuntimeState> stateStack;
    private final Integer maxSize;
    private boolean hasGap = false;

    public CifSimulatorHistory(RuntimeState initialState) {
        this.initialState = initialState;
        this.maxSize = HistorySizeOption.getMaximum();
        this.stateStack = new LinkedList<RuntimeState>();
    }

    public RuntimeState getInitialState() {
        return this.initialState;
    }

    public void addState(RuntimeState state) {
        if (!this.isUndoEnabled()) {
            return;
        }
        if (this.maxSize != null && this.stateStack.size() == this.maxSize.intValue()) {
            this.stateStack.removeFirst();
            this.hasGap = true;
        }
        this.stateStack.addLast(state);
    }

    public boolean canReset(RuntimeState state) {
        return state != this.initialState;
    }

    public boolean isUndoEnabled() {
        return this.maxSize == null || this.maxSize != 0;
    }

    public boolean canUndo(RuntimeState state, int count) {
        Assert.check((count > 0 ? 1 : 0) != 0);
        return count <= this.getMaxUndoCount(state);
    }

    public int getMaxUndoCount(RuntimeState state) {
        if (!this.isUndoEnabled()) {
            return 0;
        }
        int count = this.stateStack.size() - 1;
        if (!this.hasGap && state != this.initialState) {
            ++count;
        }
        return count;
    }

    public RuntimeState reset() {
        this.stateStack.clear();
        this.hasGap = false;
        return this.initialState;
    }

    public RuntimeState undo(int count) {
        Assert.check((count > 0 ? 1 : 0) != 0);
        Assert.check((this.stateStack.size() >= count ? 1 : 0) != 0);
        int i = 0;
        while (i < count) {
            this.stateStack.removeLast();
            ++i;
        }
        if (!this.stateStack.isEmpty()) {
            return this.stateStack.peekLast();
        }
        Assert.check((!this.hasGap ? 1 : 0) != 0);
        return this.initialState;
    }
}

