/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.appsview.ui.commands;

import java.util.Set;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.ItemType;
import org.eclipse.escet.common.app.framework.appsview.ui.AppsView;
import org.eclipse.escet.common.app.framework.appsview.ui.commands.CommandUtils;
import org.eclipse.escet.common.app.framework.appsview.ui.commands.RemoveCommandBase;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class RemoveCommand
extends RemoveCommandBase {
    @Override
    public String getIconUri() {
        return "platform:/plugin/org.eclipse.escet.common.app.framework.appsview.ui/icons/command_remove.png";
    }

    @Override
    public String getItemLabel() {
        return "Re&move";
    }

    @Override
    public String getTooltip() {
        return "Remove all selected applications that have terminated";
    }

    @Override
    public String getContributionUri() {
        return "bundleclass://org.eclipse.escet.common.app.framework.appsview.ui/" + this.getClass().getName();
    }

    @Override
    public ItemType getItemType() {
        return ItemType.PUSH;
    }

    @CanExecute
    public boolean isEnabled(MPart part) {
        return this.canRemove(part);
    }

    private boolean canRemove(MPart part) {
        AppsView view = (AppsView)part.getObject();
        if (view == null) {
            return false;
        }
        Tree tree = view.getTree();
        if (tree == null || tree.isDisposed()) {
            return false;
        }
        Set<TreeItem> selectedRoots = CommandUtils.getSelectedRoots(tree);
        for (TreeItem item : selectedRoots) {
            if (!this.canRemove(view, item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void execute(MPart part) {
        AppsView view = (AppsView)part.getObject();
        if (view == null) {
            return;
        }
        Tree tree = view.getTree();
        if (tree == null || tree.isDisposed()) {
            return;
        }
        Set<TreeItem> selectedRoots = CommandUtils.getSelectedRoots(tree);
        Set rootsToRemove = Sets.setc((int)selectedRoots.size());
        for (TreeItem root : selectedRoots) {
            if (!this.canRemove(view, root)) continue;
            rootsToRemove.add(root);
        }
        view.removeRootItems(rootsToRemove);
    }
}

