/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.java.removablelist;

import java.util.List;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.removablelist.RemovableElement;

public class RemovableList<T extends RemovableElement<T>> {
    private List<T> elements = Lists.list();

    public T get(int index) {
        return (T)((RemovableElement)this.elements.get(index));
    }

    public T poll() {
        if (this.elements.isEmpty()) {
            return null;
        }
        int lastIndex = this.elements.size() - 1;
        RemovableElement last = (RemovableElement)this.elements.get(lastIndex);
        Assert.check(last.getListIndex() == lastIndex);
        last.clearListIndex();
        this.elements.remove(lastIndex);
        return (T)last;
    }

    public int size() {
        return this.elements.size();
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public void clear() {
        for (RemovableElement elm : this.elements) {
            elm.clearListIndex();
        }
        this.elements.clear();
    }

    T elementRemove(int index) {
        RemovableElement removed = (RemovableElement)this.elements.get(index);
        if (index < this.elements.size() - 1) {
            RemovableElement last = (RemovableElement)this.elements.get(this.elements.size() - 1);
            this.elements.set(index, last);
            last.setIndex(index);
        }
        this.elements.remove(this.elements.size() - 1);
        return (T)removed;
    }

    public int add(T element) {
        int index = this.elements.size();
        this.elements.add(element);
        ((RemovableElement)element).setListIndex(this, index);
        return index;
    }
}

