/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.Request;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.codec.binary.Base64;

public class BasicAuthenticator
extends AuthenticatorBase {
    private static final Log log = LogFactory.getLog(BasicAuthenticator.class);
    protected static final String info = "org.apache.catalina.authenticator.BasicAuthenticator/1.0";

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public boolean authenticate(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        if (this.checkForCachedAuthentication(request, response, true)) {
            return true;
        }
        String username = null;
        String password = null;
        MessageBytes authorization = request.getCoyoteRequest().getMimeHeaders().getValue("authorization");
        if (authorization != null) {
            Principal principal;
            authorization.toBytes();
            ByteChunk authorizationBC = authorization.getByteChunk();
            if (authorizationBC.startsWithIgnoreCase("basic ", 0)) {
                authorizationBC.setOffset(authorizationBC.getOffset() + 6);
                byte[] decoded = Base64.decodeBase64((byte[])authorizationBC.getBuffer(), (int)authorizationBC.getOffset(), (int)authorizationBC.getLength());
                int colon = -1;
                for (int i = 0; i < decoded.length; ++i) {
                    if (decoded[i] != 58) continue;
                    colon = i;
                    break;
                }
                if (colon < 0) {
                    username = new String(decoded, B2CConverter.ISO_8859_1);
                } else {
                    username = new String(decoded, 0, colon, B2CConverter.ISO_8859_1);
                    password = new String(decoded, colon + 1, decoded.length - colon - 1, B2CConverter.ISO_8859_1);
                }
                authorizationBC.setOffset(authorizationBC.getOffset() - 6);
            }
            if ((principal = this.context.getRealm().authenticate(username, password)) != null) {
                this.register(request, response, principal, "BASIC", username, password);
                return true;
            }
        }
        StringBuilder value = new StringBuilder(16);
        value.append("Basic realm=\"");
        if (config.getRealmName() == null) {
            value.append("Authentication required");
        } else {
            value.append(config.getRealmName());
        }
        value.append('\"');
        response.setHeader("WWW-Authenticate", value.toString());
        response.sendError(401);
        return false;
    }

    @Override
    protected String getAuthMethod() {
        return "BASIC";
    }
}

