/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.wizard;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.gendoc.GendocProcess;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.IGendocDiagnostician;
import org.eclipse.gendoc.services.IProgressMonitorService;
import org.eclipse.gendoc.services.exception.GenDocException;
import org.eclipse.gendoc.tags.handlers.IConfigurationService;
import org.eclipse.gendoc.wizard.Activator;
import org.eclipse.gendoc.wizard.AdditionnalParameterItem;
import org.eclipse.gendoc.wizard.GendocWizardPage;
import org.eclipse.gendoc.wizard.IGendocRunner;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GendocWizard
extends Wizard {
    private final List<IGendocRunner> runners = new ArrayList<IGendocRunner>();
    private final IFile[] files;
    private GendocWizardPage page;
    private static final String mymessage = "Error generating documentation.\nYou can save the template";

    public GendocWizard(List<IGendocRunner> runners, IFile[] files) {
        if (runners != null) {
            this.runners.addAll(runners);
        }
        Collections.sort(this.runners, new Comparator<IGendocRunner>(){

            @Override
            public int compare(IGendocRunner o1, IGendocRunner o2) {
                String label1 = o1.getLabel() != null ? o1.getLabel() : "";
                String label2 = o2.getLabel() != null ? o2.getLabel() : "";
                return label1.compareTo(label2);
            }
        });
        this.files = files;
        this.setWindowTitle("Generate Documentation");
    }

    public void addPages() {
        this.page = new GendocWizardPage();
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        if (this.page.getAdditionnalParameters() != null && !this.page.getAdditionnalParameters().isEmpty()) {
            for (AdditionnalParameterItem item : this.page.getAdditionnalParameters()) {
                if (item.getValue() != null && !"".equals(item.getValue())) continue;
                String message = "Please Fill all additionnal parameters fields \n ";
                MessageDialog.openError((Shell)this.getShell(), (String)"Document generator", (String)message);
                return false;
            }
        }
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    IGendocDiagnostician diagnostician = (IGendocDiagnostician)GendocServices.getDefault().getService(IGendocDiagnostician.class);
                    diagnostician.init();
                    IProgressMonitorService monitorService = (IProgressMonitorService)GendocServices.getDefault().getService(IProgressMonitorService.class);
                    monitorService.setMonitor(monitor);
                    try {
                        try {
                            IConfigurationService parameter = (IConfigurationService)GendocServices.getDefault().getService(IConfigurationService.class);
                            parameter.addParameter(GendocWizard.this.replacePercentBySpace(GendocWizard.this.page.getSelected().getOutputKey(), 3), GendocWizard.this.replacePercentBySpace(GendocWizard.this.page.getFullOutputPath(), 3));
                            parameter.addParameter(GendocWizard.this.replacePercentBySpace(GendocWizard.this.page.getSelected().getModelKey(), 3), GendocWizard.this.replacePercentBySpace(GendocWizard.this.page.getModel(), 3));
                            for (AdditionnalParameterItem item : GendocWizard.this.page.getAdditionnalParameters()) {
                                parameter.addParameter(GendocWizard.this.replacePercentBySpace(item.getParamName(), 3), GendocWizard.this.replacePercentBySpace(item.getValue(), 3));
                            }
                            GendocProcess gendocProcess = new GendocProcess();
                            String resultFile = gendocProcess.runProcess(GendocWizard.this.page.getSelected().getTemplate());
                            this.handleDiagnostic(diagnostician.getResultDiagnostic(), "The file has been generated but contains errors :\n", resultFile);
                        }
                        catch (GenDocException e) {
                            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.gendoc.wizard", e.getUIMessage(), (Throwable)e));
                            diagnostician.addDiagnostic((Diagnostic)new BasicDiagnostic(4, "org.eclipse.gendoc.wizard", 0, e.getUIMessage(), null));
                            this.handleDiagnostic(diagnostician.getResultDiagnostic(), "An error occured during generation.", null);
                            GendocServices.getDefault().clear();
                        }
                        catch (Throwable t) {
                            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.gendoc.wizard", t.getMessage(), t));
                            diagnostician.addDiagnostic((Diagnostic)new BasicDiagnostic(4, "org.eclipse.gendoc.wizard", 0, t.getMessage(), (Object[])t.getStackTrace()));
                            this.handleDiagnostic(diagnostician.getResultDiagnostic(), "An unexpected error occured during the generation.", null);
                            GendocServices.getDefault().clear();
                        }
                    }
                    finally {
                        GendocServices.getDefault().clear();
                    }
                }

                private void handleDiagnostic(final Diagnostic resultDiagnostic, String message, final String resultFilePath) {
                    if (resultDiagnostic.getSeverity() == 0) {
                        Display.getDefault().syncExec(new Runnable(){

                            public void run() {
                                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Document generator", (String)("The document has been generated successfully: \n" + resultFilePath));
                            }
                        });
                    } else {
                        Display.getDefault().syncExec(new Runnable(){

                            public void run() {
                                ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Document generator", (String)GendocWizard.mymessage, (IStatus)BasicDiagnostic.toIStatus((Diagnostic)resultDiagnostic));
                            }
                        });
                    }
                }
            });
            return true;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (Exception exception) {
            ((WizardPage)this.getContainer().getCurrentPage()).setErrorMessage("Error while generating documentation.");
            return false;
        }
    }

    public List<IGendocRunner> getRunners() {
        return this.runners;
    }

    public IFile[] getInputFiles() {
        return this.files;
    }

    public boolean canFinish() {
        if (this.getRunners().size() == 0) {
            ((WizardPage)this.getContainer().getCurrentPage()).setErrorMessage("no gendoc templates registered to this platform for the current selection");
            return false;
        }
        boolean state = true;
        int cpteur = 1;
        if (this.getContainer().getCurrentPage() == null) {
            return false;
        }
        ((WizardPage)this.getContainer().getCurrentPage()).setErrorMessage(null);
        StringBuffer message = new StringBuffer();
        String path = this.page.getOutputPath();
        File f = new File(path);
        if (!f.isDirectory() || !f.exists()) {
            message.append(String.valueOf(cpteur) + " : Please specify a directory path in the path field \n ");
            state = false;
            ++cpteur;
        }
        if (!this.page.isCorrectExtension()) {
            message.append(" " + cpteur + " : OutPut file extension is not correct\n ");
            ++cpteur;
            state = false;
        }
        if (!this.page.allIsFilled()) {
            message.append(" " + cpteur + " : Please Fill all parameters fields \n ");
            state = false;
        }
        if (!state) {
            ((WizardPage)this.getContainer().getCurrentPage()).setErrorMessage(message.toString());
            return false;
        }
        return true;
    }

    public void refresh() {
        this.getContainer().updateButtons();
        this.getContainer().updateMessage();
    }

    public String replacePercentBySpace(String theString, int pas) {
        StringBuffer buffer = new StringBuffer(theString);
        int pos = 1;
        while (theString.contains("%")) {
            pos = theString.indexOf("%");
            theString = buffer.replace(pos, pos + pas, " ").toString();
        }
        return theString;
    }
}

