/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.m2t.impl;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gendoc.m2t.IM2TProcessor;
import org.eclipse.gendoc.m2t.IScriptLanguageExtensionService;
import org.eclipse.gendoc.m2t.impl.ScriptLanguagesExtensionPoint;
import org.eclipse.gendoc.services.AbstractService;
import org.eclipse.gendoc.services.exception.UnknownScriptLanguageException;

public class ScriptLanguageExtensionService
extends AbstractService
implements IScriptLanguageExtensionService {
    private Map<String, IM2TProcessor> languages = new HashMap<String, IM2TProcessor>();

    public ScriptLanguageExtensionService() {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(ScriptLanguagesExtensionPoint.EXTENSION_POINT_ID);
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                String name = element.getAttribute(ScriptLanguagesExtensionPoint.SCRIPT_LANGUAGE_NAME);
                IM2TProcessor processor = (IM2TProcessor)element.createExecutableExtension(ScriptLanguagesExtensionPoint.SCRIPT_LANGUAGE_PROCESSOR);
                if (processor != null) {
                    this.languages.put(name, processor);
                }
            }
            catch (InvalidRegistryObjectException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public void clear() {
        this.languages.clear();
    }

    public IM2TProcessor getProcessor(String languageName) throws UnknownScriptLanguageException {
        if (!this.languages.containsKey(languageName)) {
            throw new UnknownScriptLanguageException(languageName);
        }
        return this.languages.get(languageName);
    }
}

