/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.bundle.acceleo.gmf.service;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gendoc.bundle.acceleo.gmf.impl.GMFDiagramRunnable;
import org.eclipse.gendoc.documents.IAdditionalResourceService;
import org.eclipse.gendoc.documents.IDocumentService;
import org.eclipse.gendoc.documents.ResourceRunnable;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.IGendocDiagnostician;
import org.eclipse.gendoc.services.IRegistryService;
import org.eclipse.gendoc.services.utils.DefaultImageExtensionUtils;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;

public class GMFServices {
    private static final String KEY_DIAGRAM_MAP = "key";

    public Boolean isDiagramEmpty(Diagram diagram) {
        return this.getElementsInDiagram(diagram).isEmpty();
    }

    public String getDiagram(Diagram diagram) {
        return this.getDiagram(diagram, null);
    }

    public String getDiagram(Diagram diagram, List<EObject> visibleElements) {
        return this.getDiagramExt(diagram, DefaultImageExtensionUtils.getDefaultImageExtension(), visibleElements);
    }

    public String getDiagramExt(Diagram diagram, String ext) {
        return this.getDiagramExt(diagram, ext, null);
    }

    public String getDiagramExt(Diagram diagram, String ext, List<EObject> visibleElements) {
        if (diagram != null) {
            GMFDiagramRunnable runnable = new GMFDiagramRunnable(diagram, ext, visibleElements);
            IDocumentService docService = (IDocumentService)GendocServices.getDefault().getService(IDocumentService.class);
            IAdditionalResourceService resourceService = docService.getAdditionalResourceService();
            return resourceService.addNewImageRunnable((ResourceRunnable)runnable);
        }
        return null;
    }

    public List<Diagram> getDiagramsUsingNotation(EObject e) {
        return this.getDiagramsUsingExtension(e, "notation");
    }

    public List<Diagram> getDiagramsUsingExtension(EObject e, String extension) {
        URI uri = e.eResource().getURI();
        URI newURI = uri.trimFileExtension().appendFileExtension(extension);
        return this.getDiagramsInResource(e, newURI);
    }

    public List<Diagram> getDiagramsUsingRelativePath(EObject e, String relativePath) {
        if (e == null || e.eResource() == null || relativePath == null) {
            return null;
        }
        URI uri = URI.createURI((String)(String.valueOf(e.eResource().getURI().trimSegments(1).toString()) + "/"));
        URI r = URI.createURI((String)relativePath).resolve(uri);
        return this.getDiagramsInResource(e, r);
    }

    public List<Diagram> getDiagramsUsingAbsolutePath(EObject e, String absolutePath) {
        if (e == null || e.eResource() == null || absolutePath == null) {
            return null;
        }
        return this.getDiagramsInResource(e, URI.createFileURI((String)absolutePath));
    }

    private List<Diagram> getDiagramsInResource(EObject e, URI uri) {
        return this.getDiagrams(e, uri);
    }

    public List<Diagram> getDiagramsInModel(EObject e) {
        if (e == null || e.eResource() == null) {
            return null;
        }
        return this.getDiagramsInResource(e, e.eResource().getURI());
    }

    public List<Diagram> getDiagrams(EObject e, URI uri) {
        if (e == null || e.eResource() == null || uri == null) {
            return null;
        }
        IRegistryService registry = (IRegistryService)GendocServices.getDefault().getService(IRegistryService.class);
        if (registry != null) {
            LinkedList<Diagram> diagrams;
            HashMap<URI, LinkedList<Diagram>> map = (HashMap<URI, LinkedList<Diagram>>)registry.get((Object)KEY_DIAGRAM_MAP);
            if (map == null) {
                map = new HashMap<URI, LinkedList<Diagram>>();
                registry.put((Object)KEY_DIAGRAM_MAP, map);
            }
            if ((diagrams = (LinkedList<Diagram>)map.get(uri)) == null) {
                diagrams = new LinkedList<Diagram>();
                Resource diResource = null;
                if (e.eResource().getURI().equals(uri)) {
                    diResource = e.eResource();
                } else {
                    try {
                        diResource = e.eResource().getResourceSet().getResource(uri, true);
                    }
                    catch (WrappedException ex) {
                        IGendocDiagnostician diag = (IGendocDiagnostician)GendocServices.getDefault().getService(IGendocDiagnostician.class);
                        diag.addDiagnostic((Diagnostic)new BasicDiagnostic(4, "org.eclipse.gendoc.bundle.acceleo.gmf", 0, String.format("Resource %s not found", uri.toString()), new Object[]{e}));
                        ex.printStackTrace();
                    }
                }
                TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((ResourceSet)diResource.getResourceSet());
                if (domain == null) {
                    TransactionalEditingDomainImpl.FactoryImpl.INSTANCE.createEditingDomain(diResource.getResourceSet());
                }
                TreeIterator i = EcoreUtil.getAllProperContents((Resource)diResource, (boolean)true);
                while (i.hasNext()) {
                    EObject eobject = (EObject)i.next();
                    if (!(eobject instanceof Diagram)) continue;
                    Diagram diagram = (Diagram)eobject;
                    diagrams.add(diagram);
                }
                map.put(uri, diagrams);
            }
            if (!diagrams.isEmpty()) {
                return this.getDiagramsForElement(e, diagrams);
            }
            return null;
        }
        return null;
    }

    protected List<Diagram> getDiagramsForElement(EObject e, List<Diagram> diagrams) {
        LinkedList<Diagram> diagramsForParameters = new LinkedList<Diagram>();
        for (Diagram d : diagrams) {
            if (d.getElement() == null || !d.getElement().equals(e)) continue;
            diagramsForParameters.add(d);
        }
        return diagramsForParameters;
    }

    public Collection<EObject> getElementsInDiagram(Diagram diagram) {
        HashSet<View> allViews = new HashSet<View>();
        GMFServices.getAllNestedViews((View)diagram, allViews);
        HashSet<EObject> elements = new HashSet<EObject>();
        for (View view : allViews) {
            EObject elt = view.getElement();
            if (elt == null || elt == diagram.getElement()) continue;
            elements.add(elt);
        }
        return elements;
    }

    private static void getAllNestedViews(View view, Set<View> allViews) {
        for (View childView : view.getChildren()) {
            GMFServices.getAllNestedViews(childView, allViews);
            allViews.add(childView);
        }
    }
}

