/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.document.parser.xlsx.cellmarkers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.gendoc.document.parser.documents.XMLParser;
import org.eclipse.gendoc.document.parser.documents.helper.UnitsHelper;
import org.eclipse.gendoc.document.parser.xlsx.CellRef;
import org.eclipse.gendoc.document.parser.xlsx.XLSXParser;
import org.eclipse.gendoc.document.parser.xlsx.cellmarkers.AbstractCellMarker;
import org.eclipse.gendoc.document.parser.xlsx.cellmarkers.CellMark;
import org.eclipse.gendoc.document.parser.xlsx.helper.XPathXlsxUtils;
import org.eclipse.gendoc.documents.IAdditionalResourceService;
import org.eclipse.gendoc.documents.IDocumentService;
import org.eclipse.gendoc.documents.IImageService;
import org.eclipse.gendoc.documents.ImageDimension;
import org.eclipse.gendoc.services.GendocServices;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImageRefMarker
extends AbstractCellMarker {
    public ImageRefMarker() {
        super("image", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/drawing", "/xdr:wsDr/xdr:twoCellAnchor");
    }

    @Override
    protected CellMark getCellMark(Element markEl) {
        Element cellEl = (Element)markEl.getParentNode();
        ImageCellMark cm = new ImageCellMark(new CellRef(cellEl.getAttribute("r")), new CellRef(cellEl.getAttribute("r")), markEl.getAttribute("id"), markEl.getAttribute("xlpart"), markEl.getAttribute("path").replace("['['/]", "[").replace("[']'/]", "]"), markEl.getAttribute("kind"));
        cm.imageId = markEl.getAttribute("imageId");
        cm.keepW = Boolean.parseBoolean(markEl.getAttribute("keepW"));
        cm.keepH = Boolean.parseBoolean(markEl.getAttribute("keepH"));
        cm.maxH = Boolean.parseBoolean(markEl.getAttribute("maxH"));
        cm.maxW = Boolean.parseBoolean(markEl.getAttribute("maxW"));
        return cm;
    }

    @Override
    public List<CellMark> getMarksToApply(XLSXParser xlsxParser) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public void setMarks(XLSXParser parser) {
    }

    @Override
    public List<CellMark> getAppliedMarks(XLSXParser parser) {
        ArrayList<CellMark> res = new ArrayList<CellMark>();
        try {
            NodeList refs = XPathXlsxUtils.evaluateNodes(parser.getDocument(), "//:row/:c[contains(.//:t/text(),'<gendoc:mark id=\"image\"')]");
            int i = 0;
            while (i < refs.getLength()) {
                int is;
                Element markEl = (Element)refs.item(i);
                String content = markEl.getTextContent();
                int ie = content.indexOf("/>", is = content.indexOf("<gendoc:mark id=\"image\""));
                if (ie > 0) {
                    Node n;
                    ie += 2;
                    while ((n = markEl.getFirstChild()) != null) {
                        markEl.removeChild(n);
                    }
                    Element el = (Element)XPathXlsxUtils.parserXmlFragment(content.substring(is, ie));
                    el = (Element)markEl.appendChild(markEl.getOwnerDocument().importNode(el, true));
                    CellMark m = this.getCellMark(el);
                    res.add(m);
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        return res;
    }

    @Override
    public void layoutCells(XLSXParser parser, List<CellMark> targets) {
        if (targets == null || targets.size() == 0) {
            return;
        }
        IDocumentService documentService = (IDocumentService)GendocServices.getDefault().getService(IDocumentService.class);
        IAdditionalResourceService additionalResourceService = documentService.getAdditionalResourceService();
        IImageService imageService = additionalResourceService.getImageService();
        try {
            XMLParser xlDrawing = parser.loadImplicitPartDocument("http://schemas.openxmlformats.org/officeDocument/2006/relationships/drawing");
            for (CellMark m : targets) {
                ImageCellMark mark = (ImageCellMark)m;
                CellRef target = mark.cell;
                ImageDimension imDim = imageService.resizeImage(parser.getXLSXDocument().getUnzipLocationDocumentFile() + File.separator + additionalResourceService.getImageRelativePath(mark.imageId).replace('/', File.separatorChar), (double)parser.calculateColumnWidth(target.getCol() + 1), (double)parser.calculateRowHeight(target.getRow() + 1), mark.keepH, mark.keepW, mark.maxH, mark.maxW);
                long widthInEmu = (long)UnitsHelper.convertFromPixels((double)imDim.getWidth(), (int)96, (UnitsHelper.Unit)UnitsHelper.Unit.EMU);
                long heightInEmu = (long)UnitsHelper.convertFromPixels((double)imDim.getHeight(), (int)96, (UnitsHelper.Unit)UnitsHelper.Unit.EMU);
                Element anchorEl = (Element)XPathXlsxUtils.evaluateNode(xlDrawing.getDocument(), mark.path);
                Element fromCol = (Element)XPathXlsxUtils.evaluateNode(anchorEl, "./xdr:from/xdr:col");
                fromCol.setTextContent(String.valueOf(target.getCol()));
                Element fromRow = (Element)XPathXlsxUtils.evaluateNode(anchorEl, "./xdr:from/xdr:row");
                fromRow.setTextContent(String.valueOf(target.getRow()));
                Element toCol = (Element)XPathXlsxUtils.evaluateNode(anchorEl, "./xdr:to/xdr:col");
                toCol.setTextContent(String.valueOf(target.getCol()));
                Element toColOff = (Element)XPathXlsxUtils.evaluateNode(anchorEl, "./xdr:to/xdr:colOff");
                toColOff.setTextContent(String.valueOf(widthInEmu));
                Element toRow = (Element)XPathXlsxUtils.evaluateNode(anchorEl, "./xdr:to/xdr:row");
                toRow.setTextContent(String.valueOf(target.getRow()));
                Element toRowOff = (Element)XPathXlsxUtils.evaluateNode(anchorEl, "./xdr:to/xdr:rowOff");
                toRowOff.setTextContent(String.valueOf(heightInEmu));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static final class ImageCellMark
    extends CellMark {
        private String imageId;
        private boolean keepH;
        private boolean keepW;
        private boolean maxH;
        private boolean maxW;

        public ImageCellMark(CellRef srcRef, CellRef cellRef, String id, String xlPart, String path, String kind) {
            super(srcRef, cellRef, id, xlPart, path, kind);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.imageId == null ? 0 : this.imageId.hashCode());
            result = 31 * result + (this.keepH ? 1231 : 1237);
            result = 31 * result + (this.keepW ? 1231 : 1237);
            result = 31 * result + (this.maxH ? 1231 : 1237);
            result = 31 * result + (this.maxW ? 1231 : 1237);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ImageCellMark other = (ImageCellMark)obj;
            if (this.imageId == null ? other.imageId != null : !this.imageId.equals(other.imageId)) {
                return false;
            }
            if (this.keepH != other.keepH) {
                return false;
            }
            if (this.keepW != other.keepW) {
                return false;
            }
            if (this.maxH != other.maxH) {
                return false;
            }
            return this.maxW == other.maxW;
        }
    }
}

