/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.document.parser.xlsx.cellmarkers;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.gendoc.document.parser.xlsx.cellmarkers.CellMark;
import org.eclipse.gendoc.document.parser.xlsx.cellmarkers.CellRangeRefMarker;
import org.eclipse.gendoc.document.parser.xlsx.cellmarkers.ICellRefMarker;

public class UnionCellRangeRefMarker
extends CellRangeRefMarker
implements ICellRefMarker {
    public UnionCellRangeRefMarker(String mark, String xpath, String attrPath) {
        super(mark, xpath, attrPath);
    }

    public UnionCellRangeRefMarker(String mark, String relationType, String xpath, String attrPath) {
        super(mark, relationType, xpath, attrPath);
    }

    @Override
    protected Map<String, List<CellMark>[]> calculateMarkRanges(List<CellMark> marks) {
        Map<String, List<CellMark>[]> markRanges = super.calculateMarkRanges(marks);
        for (List<CellMark>[] ls : markRanges.values()) {
            int r = 0;
            while (r < ls.length) {
                CellMark min = null;
                CellMark max = null;
                for (CellMark m : ls[r]) {
                    if (min != null && m.cell.compareTo(min.cell) >= 0) continue;
                    min = m;
                }
                for (CellMark m : ls[r + 1]) {
                    if (max != null && m.cell.compareTo(max.cell) <= 0) continue;
                    max = m;
                }
                ls[r] = Collections.singletonList(min);
                ls[r + 1] = Collections.singletonList(max);
                r += 2;
            }
        }
        return markRanges;
    }
}

