/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.services.pptx;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.core.runtime.Path;
import org.eclipse.gendoc.document.parser.documents.XMLParser;
import org.eclipse.gendoc.document.parser.pptx.PPTXDocument;
import org.eclipse.gendoc.document.parser.pptx.XPathPptxUtils;
import org.eclipse.gendoc.documents.AdditionalResourceService;
import org.eclipse.gendoc.documents.FileRunnable;
import org.eclipse.gendoc.documents.IAdditionalResourceService;
import org.eclipse.gendoc.documents.IDocumentManager;
import org.eclipse.gendoc.documents.IDocumentService;
import org.eclipse.gendoc.documents.IImageService;
import org.eclipse.gendoc.documents.MimeTypes;
import org.eclipse.gendoc.documents.ResourceRunnable;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.ILogger;
import org.eclipse.gendoc.services.exception.AdditionalResourceException;
import org.eclipse.gendoc.services.pptx.PPTXDocumentService;
import org.eclipse.gendoc.services.pptx.PPTXImageService;
import org.eclipse.gendoc.services.utils.DefaultImageExtensionUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PPTXAdditionalResourceService
extends AdditionalResourceService
implements IAdditionalResourceService {
    private IImageService imageService;
    private List<Element> relationshipsToAdd = new ArrayList<Element>();
    protected Map<String, String> externalChunkMap = new LinkedHashMap<String, String>();

    public PPTXAdditionalResourceService() {
        this.imageService = new PPTXImageService();
    }

    public IImageService getImageService() {
        return this.imageService;
    }

    public String includeFile(String filePath) {
        String id = this.generateUniqueId();
        this.externalChunkMap.put(id, filePath);
        this.fileExtensions.add(Path.fromOSString((String)filePath).getFileExtension());
        return id;
    }

    public void includeExtensions(Set<String> fileExt) {
        this.fileExtensions.addAll(fileExt);
    }

    public void addAdditionalResourcesToDocument() throws AdditionalResourceException {
        String mediaLoc = this.getResourceFolder();
        IDocumentManager docManager = (IDocumentManager)GendocServices.getDefault().getService(IDocumentManager.class);
        PPTXDocument pptxDocument = (PPTXDocument)docManager.getDocTemplate();
        PPTXDocumentService cfr_ignored_0 = (PPTXDocumentService)GendocServices.getDefault().getService(IDocumentService.class);
        File mediaDir = new File(mediaLoc);
        if (!mediaDir.exists()) {
            mediaDir.mkdir();
        }
        this.addImagesResourcesToDocument(mediaLoc);
        this.addExternalResourcesToDocument(mediaLoc);
        String relsLocation = String.valueOf(this.SEPARATOR) + "ppt" + this.SEPARATOR + "slides" + this.SEPARATOR + "_rels" + this.SEPARATOR;
        this.addRelationShipFiles(pptxDocument, relsLocation);
        this.modifyContentTypes(pptxDocument);
    }

    public String addRunnableResourceToDocument(String mediaLoc, String diagramKey) throws AdditionalResourceException {
        if (this.runnableMap.get(diagramKey) == null) {
            throw new AdditionalResourceException("Image with id '" + diagramKey + "' cannot be found.");
        }
        ResourceRunnable runnable = (ResourceRunnable)this.runnableMap.get(diagramKey);
        String extension = this.getFileExtensionFromRunnable(runnable);
        runnable.run(diagramKey, this.getResourceFolder());
        this.relationshipsToAdd.add(this.newImageRelationship(diagramKey, String.valueOf(diagramKey) + "." + extension));
        this.fileExtensions.add(extension);
        return String.valueOf(this.getResourceFolder()) + this.SEPARATOR + diagramKey + "." + extension;
    }

    protected String getRelativeResourceFolder() {
        return "ppt" + this.SEPARATOR + "media";
    }

    private void addImagesResourcesToDocument(String mediaLoc) throws AdditionalResourceException {
        for (String imageKey : this.imagesMap.keySet()) {
            File imageFile = new File((String)this.imagesMap.get(imageKey));
            String imageLink = String.valueOf(imageKey) + "." + Path.fromOSString((String)imageFile.getAbsolutePath()).getFileExtension();
            try {
                this.copyImage(imageFile, String.valueOf(mediaLoc) + this.SEPARATOR + imageLink);
            }
            catch (IOException e) {
                throw new AdditionalResourceException("File '" + imageFile.getAbsolutePath() + "'cannot be copied.", (Throwable)e);
            }
            this.relationshipsToAdd.add(this.newImageRelationship(imageKey, imageLink));
            if (imageFile.exists()) continue;
            throw new AdditionalResourceException("An image cannot be generated and has been replaced by a red cross. Cause: No image found at location:" + imageFile.getAbsolutePath());
        }
    }

    private void addExternalResourcesToDocument(String mediaLoc) throws AdditionalResourceException {
    }

    private void addRelationShipFiles(PPTXDocument pptxDocument, String relsLocation) throws AdditionalResourceException {
        if (this.relationshipsToAdd == null) {
            return;
        }
        ILogger logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
        File wordDir = new File(pptxDocument.getUnzipLocationDocumentFile() + File.separator + relsLocation + File.separator + "..");
        if (!wordDir.isDirectory()) {
            return;
        }
        String[] fileNames = wordDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return (name = name.toLowerCase()).startsWith("slide") && name.endsWith(".xml");
            }
        });
        try {
            String[] stringArray = fileNames;
            int n = fileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                String relpath = String.valueOf(relsLocation) + fileName + ".rels";
                XMLParser relParser = pptxDocument.getSubdocument(relpath);
                if (relParser == null) {
                    relParser = pptxDocument.createSubdocument(relpath, (CharSequence)"<?xml version=\"1.0\" encoding=\"windows-1250\"?> <Relationships xmlns=\"http://schemas.openxmlformats.org/package/2006/relationships\"/>");
                }
                try {
                    for (Element relToAdd : this.relationshipsToAdd) {
                        if (XPathPptxUtils.INSTANCE.evaluateNode((Node)relParser.getDocument(), "/rel:Relationships/rel:Relationship[@Id='" + relToAdd.getAttribute("Id") + "']") != null) continue;
                        relParser.getDocument().getDocumentElement().appendChild(relParser.getDocument().importNode(relToAdd, true));
                    }
                }
                catch (XPathExpressionException e) {
                    throw new IllegalArgumentException(e);
                }
                ++n2;
            }
        }
        catch (IOException iOException) {
            logger.log("Mapping files for headers and footers are not copied properly. Some images in headers and footers can be missing.", 1);
        }
    }

    private void modifyContentTypes(PPTXDocument pptxDocument) throws AdditionalResourceException {
        XMLParser ctParser = pptxDocument.getSubdocument("/[Content_Types].xml");
        try {
            for (String extension : this.fileExtensions) {
                if (XPathPptxUtils.INSTANCE.evaluateNode((Node)ctParser.getDocument(), "/ct:Types/ct:Default[@Extension='" + extension + "']") != null) continue;
                Element extEl = ctParser.getDocument().createElementNS("http://schemas.openxmlformats.org/package/2006/content-types", "Default");
                extEl.setAttribute("ContentType", MimeTypes.getMimeTypefromExtension((String)extension));
                extEl.setAttribute("Extension", extension);
                ctParser.getDocument().getDocumentElement().insertBefore(extEl, ctParser.getDocument().getDocumentElement().getFirstChild());
            }
        }
        catch (Exception e) {
            throw new AdditionalResourceException((Throwable)e);
        }
    }

    private Element newImageRelationship(String imageKey, String imageLink) {
        try {
            return (Element)XPathPptxUtils.INSTANCE.parserXmlFragment("<rel:Relationship Id=\"" + imageKey + "\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/image\" Target=\"../media/" + imageLink + "\"/>");
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private String newExternalChunkRelationship(String key, String target) {
        return "<Relationship Id=\"" + key + "\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/aFChunk\" Target=\"../media/" + target + "\"/>";
    }

    private String getFileExtensionFromRunnable(ResourceRunnable runnable) {
        if (runnable instanceof FileRunnable) {
            return ((FileRunnable)runnable).getFileExtension();
        }
        return DefaultImageExtensionUtils.getDefaultImageExtension();
    }
}

