/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.tags.handlers.impl.post;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.gendoc.document.parser.documents.Document;
import org.eclipse.gendoc.documents.IDocumentService;
import org.eclipse.gendoc.process.AbstractStepProcess;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.exception.GenDocException;
import org.eclipse.gendoc.tags.handlers.impl.RegisteredTags;
import org.w3c.dom.Node;

public class NobrTagProcess
extends AbstractStepProcess {
    protected static final Pattern NOBR_TAG_PATTERN = Pattern.compile("<\\s*" + RegisteredTags.NOBR + "\\s*/\\s*>", 8);
    IDocumentService documentService = (IDocumentService)GendocServices.getDefault().getService(IDocumentService.class);
    Pattern replacePattern = this.documentService.getNobrReplacePattern();
    List<Node> currentMerging = null;
    List<List<Node>> nodeSetToMerge = null;

    protected void doRun() throws GenDocException {
        this.currentMerging = null;
        this.nodeSetToMerge = new ArrayList<List<Node>>();
        super.doRun();
        for (List<Node> nodesToMerge : this.nodeSetToMerge) {
            StringBuffer mergedText = new StringBuffer();
            for (Node node : nodesToMerge) {
                mergedText.append(this.documentService.asText(node));
            }
            Matcher matcher = this.replacePattern.matcher(mergedText);
            StringBuffer replacedText = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(replacedText, "");
            }
            matcher.appendTail(replacedText);
            this.documentService.injectNode(nodesToMerge.get(0), replacedText.toString());
            for (Node node : nodesToMerge) {
                Node parent = node.getParentNode();
                if (parent == null) continue;
                parent.removeChild(node);
            }
        }
    }

    protected void step(Document document) throws GenDocException {
        Node currentNode = document.getXMLParser().getCurrentNode();
        if (this.documentService.isPara(currentNode.getNodeName())) {
            String text = (String)document.get(Document.PROPERTY.text);
            if (text != null && NOBR_TAG_PATTERN.matcher(text).find()) {
                if (this.currentMerging == null) {
                    this.currentMerging = new ArrayList<Node>();
                }
                this.currentMerging.add(currentNode);
            } else if (this.currentMerging != null) {
                this.currentMerging.add(currentNode);
                this.nodeSetToMerge.add(this.currentMerging);
                this.currentMerging = null;
            }
        }
    }
}

