/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.tags.handlers.impl.scripts;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.gendoc.documents.IDocumentService;
import org.eclipse.gendoc.documents.ITableService;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.ILogger;
import org.eclipse.gendoc.services.exception.GenDocException;
import org.eclipse.gendoc.services.exception.InvalidContentException;
import org.eclipse.gendoc.table.Table;
import org.eclipse.gendoc.tags.ITag;
import org.eclipse.gendoc.tags.handlers.AbstractPrePostTagHandler;
import org.eclipse.gendoc.tags.handlers.impl.RegisteredTags;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TableTagHandler
extends AbstractPrePostTagHandler {
    @Override
    public String doRun(ITag tag) throws GenDocException {
        StringBuffer returnValue;
        String value = super.doRun(tag);
        IDocumentService documentService = (IDocumentService)GendocServices.getDefault().getService(IDocumentService.class);
        ILogger logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
        String tableLabel = documentService.getTableLabel();
        Pattern tablePattern = Pattern.compile("<" + tableLabel + "[^<>]*>.*" + "</" + tableLabel + ">");
        Matcher m = tablePattern.matcher(returnValue = new StringBuffer(value));
        if (!m.find()) {
            logger.log("No table found inside <table> tag.", 2);
            return returnValue.toString();
        }
        if (tag.getAttributes().containsKey("object")) {
            Object tableModel = this.getTableModel(tag, documentService);
            int indexStart = m.start();
            int indexEnd = returnValue.lastIndexOf("</" + tableLabel + ">");
            String tableText = returnValue.substring(indexStart, indexEnd += tableLabel.length() + 3);
            String nodes = "<document>" + tableText + "</document>";
            nodes = documentService.addNamingSpaces(nodes, "document");
            Node tableNode = documentService.asNode(nodes).getFirstChild();
            ITableService tableService = documentService.getTableService();
            return tableService.manageTable(tag, documentService, returnValue, tableModel, tableNode);
        }
        int indexStart = m.start();
        int indexEnd = returnValue.lastIndexOf("</" + tableLabel + ">");
        String tableText = returnValue.substring(indexStart, indexEnd += tableLabel.length() + 3);
        String singleTable = this.concatTables(documentService, tableText);
        returnValue.replace(indexStart, indexEnd, singleTable);
        return returnValue.toString();
    }

    private Object getTableModel(ITag tag, IDocumentService documentService) {
        Table tableModel = null;
        if (tag != null && tag.getAttributes() != null) {
            String tableId = (String)tag.getAttributes().get(RegisteredTags.TABLE_OBJECT);
            ITableService tableService = documentService.getTableService();
            if (tableService != null) {
                tableModel = tableService.getTable(tableId);
            }
        }
        return tableModel;
    }

    private String concatTables(IDocumentService documentService, String tableText) throws InvalidContentException {
        String nodes = "<document>" + tableText + "</document>";
        nodes = documentService.addNamingSpaces(nodes, "document");
        Node tableNode = documentService.asNode(nodes).getFirstChild();
        Node mainTable = tableNode.getFirstChild();
        NodeList childNodes = tableNode.getChildNodes();
        int i = 1;
        while (i < childNodes.getLength()) {
            Node currentNode = childNodes.item(i);
            if (documentService.isTable(currentNode.getNodeName())) {
                NodeList rowChildNodes = currentNode.getChildNodes();
                while (rowChildNodes.getLength() > 0) {
                    Node rowNode = rowChildNodes.item(0);
                    if (documentService.isRow(rowNode.getNodeName())) {
                        mainTable.appendChild(rowNode);
                        continue;
                    }
                    rowNode.getParentNode().removeChild(rowNode);
                }
            }
            ++i;
        }
        return documentService.asText(mainTable);
    }
}

