/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.tags.parsers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.gendoc.tags.parsers.TagParserConfig;

public class TagParser {
    private String text;
    private String[] tags;
    private int pos;
    private TagKind kind;
    private List<Integer> groups;
    private List<TagKind> groupKinds;

    public TagParser(String text, List<String> tags) {
        this.text = text;
        this.tags = tags.toArray(new String[tags.size()]);
        Arrays.sort(this.tags, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.length() - o1.length();
            }
        });
        this.pos = 0;
        this.kind = TagKind.OpenTag;
        this.groups = new ArrayList<Integer>();
        this.groupKinds = new ArrayList<TagKind>();
    }

    public boolean parse() {
        while (true) {
            this.pos = this.peek("&lt;");
            if (this.pos == -1) {
                return this.groups.size() > 0;
            }
            this.groups.add(this.pos);
            if (this.match()) {
                this.groupKinds.add(this.kind);
            } else {
                this.groupKinds.add(TagKind.Incomplete);
            }
            this.groups.add(this.pos);
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean match() {
        this.lt();
        if (this.slash()) {
            this.kind = TagKind.CloseTag;
        }
        if (!this.tagName()) {
            return false;
        }
        if (this.kind == TagKind.CloseTag) {
            return this.gt();
        }
        if (this.slash_gt()) {
            this.kind = TagKind.SimpleTag;
            return true;
        }
        if (this.gt()) {
            return true;
        }
        do {
            if (!this.whites()) {
                return false;
            }
            if (!this.id()) {
                return false;
            }
            this.whites();
            if (!this.eq()) {
                return false;
            }
            this.whites();
            if (this.quote()) ** GOTO lbl28
            return false;
lbl-1000:
            // 1 sources

            {
                ++this.pos;
lbl28:
                // 2 sources

                ** while (!this.quote() && !this.eof())
            }
lbl29:
            // 1 sources

            if (this.slash_gt()) {
                this.kind = TagKind.SimpleTag;
                return true;
            }
            if (!this.gt()) continue;
            return true;
        } while (!this.eof());
        return false;
    }

    private boolean lt() {
        return this.consume("&lt;");
    }

    private boolean gt() {
        return this.consume("&gt;");
    }

    private boolean eq() {
        return this.consume("=");
    }

    private boolean slash() {
        return this.consume('/');
    }

    private boolean quote() {
        boolean res = this.consume("&apos;");
        if (res) {
            return true;
        }
        if (this.eof()) {
            return false;
        }
        char current = this.text.charAt(this.pos);
        if (TagParserConfig.INVALID_QUOTES.contains(Character.valueOf(current)) || TagParserConfig.VALID_QUOTE == current) {
            ++this.pos;
            return true;
        }
        return false;
    }

    private boolean id() {
        int prev = this.pos;
        while (!this.eof()) {
            char ch = this.text.charAt(this.pos);
            if (Character.isWhitespace(ch) || ch == '=') break;
            ++this.pos;
        }
        return this.pos != prev;
    }

    private boolean slash_gt() {
        int p = this.pos;
        if (!this.slash() || !this.gt()) {
            this.pos = p;
            return false;
        }
        return true;
    }

    private boolean whites() {
        boolean found = this.white();
        while (this.white()) {
        }
        return found;
    }

    private boolean white() {
        if (this.consume(' ', '\t', '\n', 'r')) {
            return true;
        }
        if (this.eof()) {
            return false;
        }
        char ch = this.text.charAt(this.pos);
        if (TagParserConfig.INVALID_SPACES.contains(Character.valueOf(ch))) {
            ++this.pos;
            return true;
        }
        return false;
    }

    private boolean tagName() {
        return this.consume(this.tags);
    }

    private int peek(char ch) {
        if (this.eof()) {
            return -1;
        }
        int p = this.text.indexOf(ch, this.pos);
        if (p == -1) {
            return -1;
        }
        return p;
    }

    private int peek(String token) {
        if (this.eof()) {
            return -1;
        }
        int p = this.text.indexOf(token, this.pos);
        if (p == -1) {
            return -1;
        }
        return p;
    }

    private boolean consume(char ... chars) {
        if (this.eof()) {
            return false;
        }
        char current = this.text.charAt(this.pos);
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == current) {
                ++this.pos;
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean consume(String ... tokens) {
        if (this.eof()) {
            return false;
        }
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (this.text.startsWith(token, this.pos)) {
                this.pos += token.length();
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean eof() {
        return this.pos >= this.text.length();
    }

    public static enum TagKind {
        OpenTag,
        CloseTag,
        SimpleTag,
        Incomplete;

    }
}

