/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.tags.handlers.process;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gendoc.documents.IDocumentService;
import org.eclipse.gendoc.process.AbstractProcess;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.ILogger;
import org.eclipse.gendoc.services.exception.GenDocException;
import org.eclipse.gendoc.tags.handlers.IConfigurationService;

public class RegisterVariableProcess
extends AbstractProcess {
    private static final String PROJECT_NAME = "project_name";

    protected void doRun() throws GenDocException {
        IDocumentService docService = (IDocumentService)GendocServices.getDefault().getService(IDocumentService.class);
        if (docService != null) {
            try {
                URI documentURI = docService.getDocument().getDocumentURL().toURI();
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                URI workspaceURI = root.getLocationURI();
                URI relative = workspaceURI.relativize(documentURI);
                IFile file = null;
                if (relative != null && relative.equals(documentURI)) {
                    try {
                        DocumentFinder visitor = new DocumentFinder(documentURI);
                        ResourcesPlugin.getWorkspace().getRoot().accept((IResourceVisitor)visitor);
                        file = visitor.getResult();
                    }
                    catch (CoreException e) {
                        ILogger logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
                        logger.log(e.getMessage(), 16);
                    }
                } else {
                    file = root.getFile((IPath)new Path(relative.getPath()));
                }
                if (file == null) {
                    ILogger logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
                    logger.log("variables can not be registered for " + documentURI, 2);
                } else {
                    IConfigurationService configService = (IConfigurationService)GendocServices.getDefault().getService(IConfigurationService.class);
                    IPathVariableManager manager = file.getPathVariableManager();
                    String[] keys = manager.getPathVariableNames();
                    if (keys != null) {
                        String[] stringArray = keys;
                        int n = keys.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String s = stringArray[n2];
                            URI resolveURI = manager.resolveURI(manager.getURIValue(s));
                            configService.addParameter(s, resolveURI.getPath());
                            ++n2;
                        }
                    }
                    configService.addParameter(PROJECT_NAME, file.getProject().getName());
                }
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                ILogger logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
                logger.log(e.getMessage(), 2);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                ILogger logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
                logger.log(e.getMessage(), 2);
            }
        }
    }

    protected int getTotalWork() {
        return 1;
    }

    private static boolean isImportedProjectWithNoCopy(IContainer p) {
        return !p.getProject().getLocation().removeLastSegments(1).equals((Object)ResourcesPlugin.getWorkspace().getRoot().getLocation());
    }

    private static class DocumentFinder
    implements IResourceVisitor {
        private URI documentURI = null;
        private IFile result = null;

        public DocumentFinder(URI documentURI) {
            this.documentURI = documentURI;
        }

        public IFile getResult() {
            return this.result;
        }

        public boolean visit(IResource resource) throws CoreException {
            IFile ifile;
            if (resource instanceof IWorkspaceRoot) {
                return true;
            }
            if (this.result != null) {
                return false;
            }
            if (resource instanceof IFile && (ifile = (IFile)resource).getLocationURI().equals(this.documentURI)) {
                this.result = ifile;
                return false;
            }
            return resource instanceof IContainer && RegisterVariableProcess.isImportedProjectWithNoCopy((IContainer)resource);
        }
    }
}

