/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.documents.metadata.impl;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.gendoc.document.parser.documents.Document;
import org.eclipse.gendoc.documents.metadata.IDocumentMetadataService;
import org.eclipse.gendoc.process.AbstractStepProcess;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.IRegistryService;
import org.eclipse.gendoc.services.exception.GenDocException;

public class DocumentMetadataProcess
extends AbstractStepProcess {
    private static Pattern PATTERN_PARAM = Pattern.compile("\\$\\{[a-zA-Z0-9_]+\\}");

    protected void step(Document document) throws GenDocException {
        if (document == null) {
            this.worked(1);
            return;
        }
        do {
            IDocumentMetadataService propertyService;
            if (document.getXMLParser() == null || document.getXMLParser().getKind() != Document.CONFIGURATION.metadata || (propertyService = (IDocumentMetadataService)GendocServices.getDefault().getService(IDocumentMetadataService.class)) == null) continue;
            boolean modify = false;
            List<String> propertyNames = propertyService.getMetadataProperties(document);
            for (String prop : propertyNames) {
                String value = propertyService.getMetadataValue(document, prop);
                String newValue = this.replaceValue(value);
                if (newValue != null && newValue.equals(value)) continue;
                propertyService.setMetadataValue(document, prop, newValue);
                modify = true;
            }
            if (!modify) continue;
            propertyService.saveMetadata(document);
        } while (document.jumpToNextFile());
        document.getXMLParser().setCurrentNode(null);
        this.worked(1);
    }

    public String replaceValue(String value) {
        if (value == null) {
            return null;
        }
        IRegistryService regService = (IRegistryService)GendocServices.getDefault().getService(IRegistryService.class);
        Matcher m = PATTERN_PARAM.matcher(value);
        StringBuffer buffer = new StringBuffer();
        int index = 0;
        while (m.find()) {
            buffer.append(value.substring(index, m.start()));
            String paramName = value.substring(m.start() + 2, m.end() - 1);
            Object objRegValue = regService.get((Object)paramName);
            if (objRegValue instanceof String) {
                buffer.append(objRegValue);
            } else {
                buffer.append("<<Cannot resolve parameter '" + paramName + "' in the registry>>");
            }
            index = m.end();
        }
        buffer.append(value.substring(index, value.length()));
        return buffer.toString();
    }
}

