/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.tags.handlers.impl.post;

import java.util.LinkedList;
import java.util.regex.Pattern;
import org.eclipse.gendoc.document.parser.documents.Document;
import org.eclipse.gendoc.document.parser.documents.helper.XMLHelper;
import org.eclipse.gendoc.documents.IDocumentService;
import org.eclipse.gendoc.process.AbstractStepProcess;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.exception.GenDocException;
import org.eclipse.gendoc.tags.handlers.impl.RegisteredTags;
import org.w3c.dom.Node;

public class DropTagProcess
extends AbstractStepProcess {
    protected static final Pattern DROP_TAG_PATTERN = Pattern.compile("<\\s*" + RegisteredTags.DROP + "\\s*/\\s*>", 8);
    protected IDocumentService documentService = (IDocumentService)GendocServices.getDefault().getService(IDocumentService.class);
    protected LinkedList<Node> nodesToRemove;

    protected void doRun() throws GenDocException {
        this.nodesToRemove = new LinkedList();
        super.doRun();
        for (Node n : this.nodesToRemove) {
            Node parent = n.getParentNode();
            if (parent == null) continue;
            parent.removeChild(n);
        }
    }

    protected void step(Document document) throws GenDocException {
        String text;
        Node currentNode = document.getXMLParser().getCurrentNode();
        if (this.documentService.isPara(currentNode.getNodeName()) && (text = (String)document.get(Document.PROPERTY.text)) != null && DROP_TAG_PATTERN.matcher(text).find()) {
            Node parent = currentNode.getParentNode();
            if (parent != null && this.documentService.isCell(parent.getNodeName()) && !this.hasSiblingParas(currentNode)) {
                this.cleanTextNodes(document, currentNode);
                document.getXMLParser().setCurrentNode(currentNode);
                return;
            }
            this.nodesToRemove.add(currentNode);
        }
    }

    private boolean hasSiblingParas(Node n) {
        Node sib = n.getPreviousSibling();
        while (sib != null) {
            if (this.documentService.isPara(sib.getNodeName())) {
                return true;
            }
            sib = sib.getPreviousSibling();
        }
        sib = n.getNextSibling();
        while (sib != null) {
            if (this.documentService.isPara(sib.getNodeName())) {
                return true;
            }
            sib = sib.getNextSibling();
        }
        return false;
    }

    private void cleanTextNodes(Document doc, Node para) {
        String text = (String)doc.get(Document.PROPERTY.text);
        if (!doc.next()) {
            return;
        }
        Node n = doc.getXMLParser().getCurrentNode();
        while (XMLHelper.isAncestor((Node)n, (Node)para)) {
            String value = n.getNodeValue();
            if (value != null && text.startsWith(value)) {
                text = text.substring(value.length());
                n.setNodeValue("");
            }
            if (!doc.next()) {
                return;
            }
            n = doc.getXMLParser().getCurrentNode();
        }
    }
}

