/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.tags.html.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gendoc.document.parser.documents.Document;
import org.eclipse.gendoc.documents.IDocumentService;
import org.eclipse.gendoc.services.AbstractService;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.ILogger;
import org.eclipse.gendoc.services.IRegistryService;
import org.eclipse.gendoc.services.docx.DOCXAdditionalResourceService;
import org.eclipse.gendoc.services.docx.DOCXDocumentService;
import org.eclipse.gendoc.services.docx.DOCXMimeHtmlService;
import org.eclipse.gendoc.services.utils.DeleteFileRunnable;
import org.eclipse.gendoc.tags.html.Activator;
import org.eclipse.gendoc.tags.html.IHtmlService;
import org.osgi.framework.Bundle;
import org.w3c.tidy.Tidy;

public class DOCXHtmlService
extends AbstractService
implements IHtmlService {
    private List<String> tempFiles = new LinkedList<String>();
    private boolean use2003Compatibility = false;
    private boolean isInTable = false;
    private boolean includePic = false;
    private String format = "HTML";

    public void clear() {
        for (String path : this.tempFiles) {
            File file = new File(path);
            file.delete();
        }
        this.tempFiles.clear();
    }

    @Override
    public String convert(String content) {
        if (content.length() > 0) {
            content = this.cleanDocxTagsFromHtml(content);
            if ((content = content.replace("richText&gt;", "").replaceAll("<cr>", "<br>").replaceAll("<CR>", "<BR>").replaceAll("<N>", "")).length() > 0) {
                if ("HTML".equalsIgnoreCase(this.format) && this.use2003Compatibility) {
                    return this.generateDOCXTagsFromHtml(content);
                }
                if ("HTML".equalsIgnoreCase(this.format) || "RTF".equalsIgnoreCase(this.format)) {
                    String output = "";
                    DOCXDocumentService documentService = (DOCXDocumentService)GendocServices.getDefault().getService(IDocumentService.class);
                    DOCXAdditionalResourceService additonalResourceService = (DOCXAdditionalResourceService)documentService.getAdditionalResourceService();
                    String filePath = this.createFile(content);
                    IRegistryService registry = (IRegistryService)GendocServices.getDefault().getService(IRegistryService.class);
                    registry.addCleaner((Runnable)new DeleteFileRunnable(new File(filePath)));
                    if (filePath != null) {
                        String id = additonalResourceService.includeFile(filePath);
                        output = String.valueOf(output) + "&lt;drop/&gt;";
                        output = String.valueOf(output) + "</w:t></w:r>";
                        output = String.valueOf(output) + "</w:p><w:altChunk xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" r:id=\"" + id + "\" /><w:p>";
                        output = String.valueOf(output) + "<w:r><w:t>";
                        return output;
                    }
                }
            }
        }
        return "";
    }

    private String generateDOCXTagsFromHtml(String html) {
        String output = "";
        try {
            Tidy tidy = new Tidy();
            this.configureTidy(tidy);
            ByteArrayInputStream is = new ByteArrayInputStream(html.getBytes());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.parse(tidy, is, baos);
            ((InputStream)is).close();
            String cleanedXhtml = baos.toString();
            baos.close();
            cleanedXhtml = cleanedXhtml.replace("\r", "");
            cleanedXhtml = cleanedXhtml.replace("\n", "");
            cleanedXhtml = "<root>" + cleanedXhtml + "</root>";
            StringWriter outputWriter = new StringWriter();
            StreamSource xslSource = new StreamSource(FileLocator.openStream((Bundle)Platform.getBundle((String)"org.eclipse.gendoc.tags.html"), (IPath)new Path("resources/html2docx.xsl"), (boolean)false));
            StreamSource inputSource = new StreamSource(new StringReader(cleanedXhtml));
            StreamResult outputResult = new StreamResult(outputWriter);
            Transformer transformer = TransformerFactory.newInstance().newTransformer(xslSource);
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(inputSource, outputResult);
            output = outputWriter.toString();
            output = "&lt;drop/&gt;</w:t></w:r></w:p>" + output;
        }
        catch (IOException iOException) {
            ILogger logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
            logger.log("Unable to open XSL file for HTML transformation.", 4);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            ILogger logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
            logger.log("Error in HTML transformer configuration.", 4);
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            ILogger logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
            logger.log("Error in HTML transformer factory configuration.", 4);
        }
        catch (TransformerException transformerException) {
            ILogger logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
            logger.log("Error transforming HTML.", 4);
        }
        return output;
    }

    private String createFile(String content) {
        String path = String.valueOf(Activator.getDefault().getStateLocation().toOSString()) + File.separator + EcoreUtil.generateUUID();
        if ("HTML".equalsIgnoreCase(this.format)) {
            path = this.includePic ? String.valueOf(path) + ".mht" : String.valueOf(path) + ".xhtml";
        } else if ("RTF".equalsIgnoreCase(this.format)) {
            path = String.valueOf(path) + ".rtf";
        }
        try {
            FileWriter writer = new FileWriter(path);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if ("HTML".equalsIgnoreCase(this.format)) {
                Tidy tidy = new Tidy();
                ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes());
                this.configureTidy(tidy);
                if (this.includePic) {
                    DOCXDocumentService documentService = (DOCXDocumentService)GendocServices.getDefault().getService(IDocumentService.class);
                    DOCXAdditionalResourceService additonalResourceService = (DOCXAdditionalResourceService)documentService.getAdditionalResourceService();
                    DOCXMimeHtmlService mimeHtmlService = (DOCXMimeHtmlService)documentService.getMimeHtmlService();
                    this.parse(tidy, is, baos);
                    String tidiedHtml = baos.toString();
                    baos.close();
                    String mHtml = mimeHtmlService.convertToMimeHtml(tidiedHtml);
                    Set fileExt = mimeHtmlService.getFileExtensions();
                    additonalResourceService.includeExtensions(fileExt);
                    String tidiedHtml2 = String.valueOf(mimeHtmlService.getBeginPart()) + mHtml + mimeHtmlService.getEndPart();
                    writer.write(tidiedHtml2);
                    writer.flush();
                } else {
                    this.parse(tidy, is, baos);
                    writer.write(baos.toString());
                    writer.flush();
                    baos.close();
                }
            } else if ("RTF".equalsIgnoreCase(this.format)) {
                writer.write(content);
                writer.flush();
            }
            this.tempFiles.add(path);
            writer.close();
        }
        catch (IOException iOException) {
            ILogger logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
            logger.log("Unable to create html file.", 4);
            return null;
        }
        return path;
    }

    private void parse(Tidy tidy, InputStream inputStream, OutputStream outputStream) throws IOException {
        StringWriter stringWriter = new StringWriter();
        tidy.setErrout(new PrintWriter(stringWriter));
        tidy.parse(inputStream, outputStream);
        ILogger logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
        logger.log(stringWriter.getBuffer().toString(), 16);
    }

    public void configureTidy(Tidy tidy) {
        if (!this.includePic) {
            tidy.setXHTML(true);
        }
        tidy.setShowWarnings(true);
        tidy.setMakeClean(true);
        tidy.setQuiet(false);
        tidy.setEncloseBlockText(true);
        tidy.setXmlOut(true);
    }

    @Override
    public void setVersion(String version) {
        this.use2003Compatibility = version != null && version.equals("msw2003");
    }

    @Override
    public void addAdditionalStyles(Document document) {
    }

    @Override
    public void setInTable(String inTable) {
        this.isInTable = inTable != null && inTable.equals("true");
    }

    @Override
    public void setIncludePic(String inPic) {
        this.includePic = inPic != null && inPic.equals("true");
    }

    private String cleanDocxTagsFromHtml(String htmlContent) {
        return htmlContent.replaceAll("<w:[^<]*>", "").replaceAll("</w:[^<]*>", "").replaceAll("<o:[^<]*>", "").replaceAll("</o:[^<]*>", "");
    }

    @Override
    public void setFormat(String format) {
        this.format = format;
    }
}

