/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.documents.impl;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExecutableExtensionFactory;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gendoc.document.parser.documents.Document;
import org.eclipse.gendoc.documents.IDocumentManager;
import org.eclipse.gendoc.documents.IDocumentService;
import org.eclipse.gendoc.documents.impl.DocumentTypesExtensionPoint;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.ServicesExtensionPoint;
import org.eclipse.gendoc.services.exception.DocumentServiceException;

public class DocumentServiceFactory
implements IExecutableExtensionFactory,
IExecutableExtension {
    private String serviceId;

    public Object create() throws CoreException {
        IDocumentService service;
        block7: {
            service = null;
            try {
                Document document = ((IDocumentManager)GendocServices.getDefault().getService(IDocumentManager.class)).getDocTemplate();
                if (document != null) {
                    IConfigurationElement[] elements;
                    String extension = new Path(document.getPath()).getFileExtension();
                    if (extension == null) {
                        throw new DocumentServiceException("Invalid document extension : null.");
                    }
                    IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(DocumentTypesExtensionPoint.EXTENSION_POINT_ID);
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement element = iConfigurationElementArray[n2];
                        String extensionAttribute = element.getAttribute(DocumentTypesExtensionPoint.DOCUMENT_TYPE_EXTENSION);
                        if (extension.equals(extensionAttribute)) {
                            service = (IDocumentService)element.createExecutableExtension(DocumentTypesExtensionPoint.DOCUMENT_TYPE_DOCUMENT_SERVICE);
                            service.setDocument(document);
                            service.setServiceId(this.serviceId);
                        }
                        ++n2;
                    }
                    if (service == null) {
                        throw new DocumentServiceException("Invalid document extension : " + extension);
                    }
                    break block7;
                }
                throw new IllegalStateException("Document service cannot be initialized : no document is defined.");
            }
            catch (DocumentServiceException e) {
                throw new IllegalStateException("Document service cannot be initialized.", e);
            }
        }
        return service;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        String serviceIdAttribute;
        this.serviceId = serviceIdAttribute = config.getAttribute(ServicesExtensionPoint.SERVICE_ID);
    }
}

