/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.preferences.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public abstract class TableFieldEditor
extends FieldEditor {
    private TableViewer viewer;
    private List<Object> input;
    private SelectionListener selectionListener;
    private Composite buttonBox;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;

    public TableFieldEditor() {
    }

    public TableFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    protected Table createTableControl(Composite parent) {
        Table t = new Table(parent, 67904);
        return t;
    }

    public List<Object> getInput() {
        return this.input;
    }

    public void setInput(List<Object> input) {
        this.input = input;
        if (this.viewer != null) {
            this.viewer.setInput(input);
        }
    }

    protected TableViewer getTableViewer() {
        return this.viewer;
    }

    protected Table getTable() {
        return this.viewer.getTable();
    }

    protected String createList(Object[] objs) {
        throw new UnsupportedOperationException();
    }

    protected Object[] parseString(String s) {
        throw new UnsupportedOperationException();
    }

    protected abstract Object getNewInputObject();

    protected abstract Object editInputObject(Object var1);

    protected abstract ITableLabelProvider createLabelProvider();

    protected void addPressed() {
        this.setPresentsDefaultValue(false);
        Object obj = this.getNewInputObject();
        if (obj != null) {
            int index = this.viewer.getTable().getSelectionIndex();
            if (index >= 0) {
                this.input.add(index + 1, obj);
            } else {
                this.input.add(0, obj);
            }
            this.refreshViewer();
            this.selectionChanged();
        }
    }

    protected void editPressed() {
        this.setPresentsDefaultValue(false);
        int index = this.viewer.getTable().getSelectionIndex();
        if (index >= 0) {
            Object obj = this.input.get(index);
            if ((obj = this.editInputObject(obj)) != null) {
                this.input.set(index, obj);
                this.refreshViewer();
                this.selectionChanged();
            }
        }
    }

    protected void removePressed() {
        this.setPresentsDefaultValue(false);
        int index = this.viewer.getTable().getSelectionIndex();
        if (index >= 0) {
            this.input.remove(index);
            this.viewer.getTable().select(index >= this.input.size() ? index - 1 : index);
            this.refreshViewer();
            this.selectionChanged();
        }
    }

    protected void upPressed() {
        this.swap(true);
    }

    protected void downPressed() {
        this.swap(false);
    }

    private void swap(boolean up) {
        this.setPresentsDefaultValue(false);
        Table table = this.viewer.getTable();
        int index = table.getSelectionIndex();
        int target = up ? index - 1 : index + 1;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (index >= 0 && selection.size() == 1) {
            this.input.remove(index);
            this.input.add(target, selection.getFirstElement());
            table.setSelection(target);
        }
        this.refreshViewer();
        this.selectionChanged();
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.viewer.getTable().getLayoutData()).horizontalSpan = numColumns - 1;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.createSelectionListener();
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
        Table table = this.createTableControl(parent);
        this.viewer = new TableViewer(table);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        if (this.input == null) {
            this.input = new ArrayList<Object>();
        }
        this.viewer.setInput(this.input);
        this.viewer.getTable().addSelectionListener(this.selectionListener);
        this.input = (List)this.viewer.getInput();
        gd = new GridData(768);
        gd.verticalAlignment = 4;
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = true;
        table.setLayoutData((Object)gd);
        this.buttonBox = this.getButtonBoxControl(parent);
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.buttonBox.setLayoutData((Object)gd);
    }

    public Composite getButtonBoxControl(Composite parent) {
        if (this.buttonBox == null) {
            this.buttonBox = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            this.buttonBox.setLayout((Layout)layout);
            this.createButtons(this.buttonBox);
            this.buttonBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    TableFieldEditor.this.addButton = null;
                    TableFieldEditor.this.editButton = null;
                    TableFieldEditor.this.removeButton = null;
                    TableFieldEditor.this.upButton = null;
                    TableFieldEditor.this.downButton = null;
                    TableFieldEditor.this.buttonBox = null;
                }
            });
        } else {
            this.checkParent((Control)this.buttonBox, parent);
        }
        this.selectionChanged();
        return this.buttonBox;
    }

    private void createButtons(Composite box) {
        this.addButton = this.createPushButton(box, JFaceResources.getString((String)"ListEditor.add"));
        this.editButton = this.createPushButton(box, "Edit...");
        this.removeButton = this.createPushButton(box, JFaceResources.getString((String)"ListEditor.remove"));
        this.upButton = this.createPushButton(box, JFaceResources.getString((String)"ListEditor.up"));
        this.downButton = this.createPushButton(box, JFaceResources.getString((String)"ListEditor.down"));
    }

    private Button createPushButton(Composite parent, String text) {
        Button button = new Button(parent, 8);
        button.setText(text);
        button.setFont(parent.getFont());
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        button.addSelectionListener(this.selectionListener);
        return button;
    }

    protected SelectionListener createSelectionListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Widget widget = event.widget;
                if (widget == TableFieldEditor.this.addButton) {
                    TableFieldEditor.this.addPressed();
                } else if (widget == TableFieldEditor.this.removeButton) {
                    TableFieldEditor.this.removePressed();
                } else if (widget == TableFieldEditor.this.upButton) {
                    TableFieldEditor.this.upPressed();
                } else if (widget == TableFieldEditor.this.downButton) {
                    TableFieldEditor.this.downPressed();
                } else if (widget == TableFieldEditor.this.editButton) {
                    TableFieldEditor.this.editPressed();
                } else if (widget == TableFieldEditor.this.viewer.getTable()) {
                    TableFieldEditor.this.selectionChanged();
                }
            }
        };
        return this.selectionListener;
    }

    protected void doLoad() {
        if (this.viewer != null) {
            String s = this.getPreferenceStore().getString(this.getPreferenceName());
            Object[] array = this.parseString(s);
            int i = 0;
            while (i < array.length) {
                this.input.add(array[i]);
                ++i;
            }
            this.refreshViewer();
        }
    }

    protected void doLoadDefault() {
        if (this.viewer != null) {
            this.input.clear();
            String s = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            Object[] array = this.parseString(s);
            int i = 0;
            while (i < array.length) {
                this.input.add(array[i]);
                ++i;
            }
            this.refreshViewer();
        }
    }

    protected void refreshViewer() {
        this.viewer.refresh();
    }

    protected void selectionChanged() {
        int index = this.viewer.getTable().getSelectionIndex();
        int size = this.viewer.getTable().getItemCount();
        this.editButton.setEnabled(index >= 0);
        this.removeButton.setEnabled(index >= 0);
        this.upButton.setEnabled(size > 1 && index > 0);
        this.downButton.setEnabled(size > 1 && index >= 0 && index < size - 1);
    }

    protected void doStore() {
        String s = this.createList(this.input.toArray());
        if (s != null) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), s);
        }
    }

    public int getNumberOfControls() {
        return 2;
    }
}

